/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.entity;

import com.iafenvoy.origins.data.condition.EntityCondition;
import com.iafenvoy.origins.data.condition.ItemCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public record EquippedItemCondition(EquipmentSlot equipmentSlot, ItemCondition itemCondition) implements EntityCondition
{
    public static final MapCodec<EquippedItemCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EquipmentSlot.CODEC.fieldOf("equipment_slot").forGetter(EquippedItemCondition::equipmentSlot), (App)ItemCondition.CODEC.fieldOf("item_condition").forGetter(EquippedItemCondition::itemCondition)).apply((Applicative)i, EquippedItemCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityCondition> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(@NotNull Entity entity) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity living = (LivingEntity)entity;
        if (!this.itemCondition.test(entity.level(), living.getItemBySlot(this.equipmentSlot))) return false;
        return true;
    }
}

