/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.entity;

import com.iafenvoy.origins.data.condition.EntityCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import org.jetbrains.annotations.NotNull;

public record GamemodeCondition(GameType gamemode) implements EntityCondition
{
    public static final MapCodec<GamemodeCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)GameType.CODEC.fieldOf("gamemode").forGetter(GamemodeCondition::gamemode)).apply((Applicative)i, GamemodeCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityCondition> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(@NotNull Entity entity) {
        if (!(entity instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)entity;
        if (player.gameMode.getGameModeForPlayer() != this.gamemode) return false;
        return true;
    }
}

