/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.entity;

import com.iafenvoy.origins.data.condition.EntityCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public record MobEffectCondition(Holder<MobEffect> effect, int minAmplifier, int maxAmplifier, int minDuration, int maxDuration) implements EntityCondition
{
    public static final MapCodec<MobEffectCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(MobEffectCondition::effect), (App)Codec.INT.optionalFieldOf("min_amplifier", (Object)0).forGetter(MobEffectCondition::minAmplifier), (App)Codec.INT.optionalFieldOf("max_amplifier", (Object)Integer.MAX_VALUE).forGetter(MobEffectCondition::maxAmplifier), (App)Codec.INT.optionalFieldOf("min_duration", (Object)-1).forGetter(MobEffectCondition::minDuration), (App)Codec.INT.optionalFieldOf("max_duration", (Object)Integer.MAX_VALUE).forGetter(MobEffectCondition::maxDuration)).apply((Applicative)i, MobEffectCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityCondition> codec() {
        return CODEC;
    }

    @Override
    public boolean test(@NotNull Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        MobEffectInstance instance = living.getEffect(this.effect);
        return instance != null && this.minAmplifier <= instance.getAmplifier() && instance.getAmplifier() <= this.maxAmplifier && this.minDuration <= instance.getDuration() && instance.getDuration() <= this.maxDuration;
    }
}

