/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.condition.builtin.entity;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.EntityCondition;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.origin.Origin;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record OriginCondition(Holder<Origin> origin, Optional<Holder<Layer>> layer) implements EntityCondition
{
    public static final MapCodec<OriginCondition> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Origin.CODEC.fieldOf("origin").forGetter(OriginCondition::origin), (App)Layer.CODEC.optionalFieldOf("layer").forGetter(OriginCondition::layer)).apply((Applicative)i, OriginCondition::new));

    @Override
    @NotNull
    public MapCodec<? extends EntityCondition> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(@NotNull Entity entity) {
        Map<Holder<Layer>, Holder<Origin>> map = EntityOriginAttachment.get(entity).getOriginsView();
        if (!map.containsValue(this.origin)) return false;
        if (this.layer.map(map::containsKey).orElse(true) == false) return false;
        return true;
    }
}

