/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.layer;

import com.iafenvoy.origins.data.layer.LayerRegistries;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.data.origin.OriginRegistries;
import com.iafenvoy.origins.util.RLHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public record Layer(int order, TagKey<Origin> origins, boolean enabled, Optional<GuiTitle> guiTitle, boolean allowRandom, boolean allowRandomUnchoosable, List<Holder<Origin>> excludeRandom, Optional<ResourceLocation> defaultOrigin, boolean autoChoose, boolean hidden) implements Comparable<Layer>
{
    public static final Codec<Layer> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("order", (Object)Integer.MAX_VALUE).forGetter(Layer::order), (App)TagKey.codec(OriginRegistries.ORIGIN_KEY).fieldOf("origins").forGetter(Layer::origins), (App)Codec.BOOL.optionalFieldOf("enabled", (Object)true).forGetter(Layer::enabled), (App)GuiTitle.CODEC.optionalFieldOf("gui_title").forGetter(Layer::guiTitle), (App)Codec.BOOL.optionalFieldOf("allow_random", (Object)false).forGetter(Layer::allowRandom), (App)Codec.BOOL.optionalFieldOf("allow_random_unchoosable", (Object)false).forGetter(Layer::allowRandomUnchoosable), (App)Origin.CODEC.listOf().optionalFieldOf("exclude_random", List.of()).forGetter(Layer::excludeRandom), (App)ResourceLocation.CODEC.optionalFieldOf("default_origin").forGetter(Layer::defaultOrigin), (App)Codec.BOOL.optionalFieldOf("auto_choose", (Object)false).forGetter(Layer::autoChoose), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter(Layer::hidden)).apply((Applicative)i, Layer::new));
    public static final Codec<Holder<Layer>> CODEC = RegistryFixedCodec.create(LayerRegistries.LAYER_KEY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Layer>> STREAM_CODEC = ByteBufCodecs.holderRegistry(LayerRegistries.LAYER_KEY);

    public int getOriginOptionCount(RegistryAccess access) {
        List<Holder<Origin>> choosableOrigins = this.collectChoosableOrigins(access).toList();
        int count = choosableOrigins.size();
        if (count > 1 && this.allowRandom && choosableOrigins.stream().anyMatch(x -> !this.excludeRandom.contains(x))) {
            ++count;
        }
        return count;
    }

    public Stream<Holder<Origin>> collectOrigins(RegistryAccess access) {
        return access.registryOrThrow(OriginRegistries.ORIGIN_KEY).getOrCreateTag(this.origins).stream();
    }

    public Stream<Holder<Origin>> collectChoosableOrigins(RegistryAccess access) {
        return this.collectOrigins(access).filter(x -> ((Origin)x.value()).choosable());
    }

    public Stream<Holder<Origin>> collectRandomizableOrigins(RegistryAccess access) {
        return this.collectOrigins(access).filter(x -> !this.excludeRandom.contains(x));
    }

    public Component getChooseOriginTitle() {
        return (Component)this.guiTitle.flatMap(x -> x.chooseOrigin).orElse(Component.empty());
    }

    public Component getViewOriginTitle() {
        return (Component)this.guiTitle.flatMap(x -> x.viewOrigin).orElse(Component.empty());
    }

    @Override
    public int compareTo(@NotNull Layer that) {
        return Integer.compare(this.order, that.order);
    }

    public static MutableComponent getName(Holder<Layer> layer) {
        return Layer.getName(RLHelper.id(layer));
    }

    public static MutableComponent getName(ResourceLocation id) {
        return Component.translatable((String)id.toLanguageKey("layer", "name"));
    }

    public record GuiTitle(Optional<Component> chooseOrigin, Optional<Component> viewOrigin) {
        public static final Codec<GuiTitle> CODEC = RecordCodecBuilder.create(i -> i.group((App)ComponentSerialization.CODEC.optionalFieldOf("choose_origin").forGetter(GuiTitle::chooseOrigin), (App)ComponentSerialization.CODEC.optionalFieldOf("view_origin").forGetter(GuiTitle::viewOrigin)).apply((Applicative)i, GuiTitle::new));
    }
}

