/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power;

import com.iafenvoy.origins.data.power.EmptyPower;
import com.iafenvoy.origins.data.power.PowerRegistries;
import com.iafenvoy.origins.util.codec.DefaultedCodec;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public interface Power {
    public static final Codec<Power> DIRECT_CODEC = DefaultedCodec.registryDispatch(PowerRegistries.POWER_TYPE, Power::codec, Function.identity(), EmptyPower::new);
    public static final Codec<Holder<Power>> CODEC = RegistryFixedCodec.create(PowerRegistries.POWER_KEY);

    @NotNull
    public MapCodec<? extends Power> codec();

    default public void grant(@NotNull Entity entity) {
    }

    default public void revoke(@NotNull Entity entity) {
    }

    default public void entityLoad(@NotNull Entity entity) {
    }

    default public void entitySave(@NotNull Entity entity) {
    }

    default public void tick(@NotNull Entity entity) {
    }

    default public boolean hidden() {
        return false;
    }

    default public ResourceLocation getId(RegistryAccess access) {
        return access.registryOrThrow(PowerRegistries.POWER_KEY).getKey((Object)this);
    }

    default public MutableComponent getName(RegistryAccess access) {
        return Component.translatable((String)this.getId(access).toLanguageKey("power", "name"));
    }

    default public MutableComponent getDescription(RegistryAccess access) {
        return Component.translatable((String)this.getId(access).toLanguageKey("power", "description"));
    }
}

