/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.data.power.IntervalPower;
import com.iafenvoy.origins.data.power.Power;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class DamageOverTimePower
extends IntervalPower {
    public static final MapCodec<DamageOverTimePower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.INT.optionalFieldOf("interval", (Object)20).forGetter(DamageOverTimePower::getInterval), (App)Codec.INT.optionalFieldOf("onset_delay").forGetter(DamageOverTimePower::getOnSetDelay), (App)Codec.FLOAT.fieldOf("damage").forGetter(DamageOverTimePower::getDamage), (App)Codec.FLOAT.optionalFieldOf("damage_easy").forGetter(DamageOverTimePower::getDamageEasy), (App)DamageType.CODEC.fieldOf("damage_type").forGetter(DamageOverTimePower::getDamageType)).apply((Applicative)i, DamageOverTimePower::new));
    private final int interval;
    private final Optional<Integer> onSetDelay;
    private final float damage;
    private final float damageEasy;
    private final Holder<DamageType> damageType;

    public DamageOverTimePower(int interval, Optional<Integer> onSetDelay, float damage, Optional<Float> damageEasy, Holder<DamageType> damageType) {
        super(onSetDelay.orElse(0));
        this.interval = interval;
        this.onSetDelay = onSetDelay;
        this.damage = damage;
        this.damageEasy = damageEasy.orElse(Float.valueOf(this.damage)).floatValue();
        this.damageType = damageType;
    }

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @Override
    public void intervalTick(@NotNull Entity entity) {
        entity.hurt(new DamageSource(this.damageType), entity.level().getDifficulty() == Difficulty.EASY ? this.damageEasy : this.damage);
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    public Optional<Integer> getOnSetDelay() {
        return this.onSetDelay;
    }

    public float getDamage() {
        return this.damage;
    }

    public Optional<Float> getDamageEasy() {
        return Optional.of(Float.valueOf(this.damageEasy));
    }

    public Holder<DamageType> getDamageType() {
        return this.damageType;
    }
}

