/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.util.codec.CombinedCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public record EffectImmunityPower(List<Holder<MobEffect>> effect, boolean inverted) implements Power
{
    public static final MapCodec<EffectImmunityPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)CombinedCodecs.MOB_EFFECT.fieldOf("effect").forGetter(EffectImmunityPower::effect), (App)Codec.BOOL.optionalFieldOf("inverted", (Object)false).forGetter(EffectImmunityPower::inverted)).apply((Applicative)i, EffectImmunityPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    public boolean canApply(MobEffectInstance effectInstance) {
        return this.canApply((Holder<MobEffect>)effectInstance.getEffect());
    }

    public boolean canApply(Holder<MobEffect> effect) {
        return !this.effect.contains(effect) ^ this.inverted;
    }

    @SubscribeEvent
    public static void disableEffectApply(MobEffectEvent.Applicable event) {
        for (EffectImmunityPower power : EntityOriginAttachment.get((Entity)event.getEntity()).getPowers(RegularPowers.EFFECT_IMMUNITY, EffectImmunityPower.class)) {
            if (power.canApply(event.getEffectInstance())) continue;
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }
}

