/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.event.client.ElytraTextureEvent;
import com.iafenvoy.origins.event.common.CanFlyWithoutElytraEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public record ElytraFlightPower(boolean renderElytra, Optional<ResourceLocation> textureLocation) implements Power
{
    public static final MapCodec<ElytraFlightPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("render_elytra", (Object)true).forGetter(ElytraFlightPower::renderElytra), (App)ResourceLocation.CODEC.optionalFieldOf("texture_location").forGetter(ElytraFlightPower::textureLocation)).apply((Applicative)i, ElytraFlightPower::new));
    private static final ResourceLocation ELYTRA_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/elytra.png");

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void enableElytraFly(CanFlyWithoutElytraEvent event) {
        if (!EntityOriginAttachment.get(event.getEntity()).getPowers(RegularPowers.ELYTRA_FLIGHT, ElytraFlightPower.class).isEmpty()) {
            event.allow();
        }
    }

    @SubscribeEvent
    public static void enableElytraRender(ElytraTextureEvent event) {
        for (ElytraFlightPower power : EntityOriginAttachment.get((Entity)event.getEntity()).getPowers(RegularPowers.ELYTRA_FLIGHT, ElytraFlightPower.class)) {
            if (!power.renderElytra) continue;
            event.setTexture(power.textureLocation.orElse(ELYTRA_TEXTURE));
            break;
        }
    }
}

