/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.EntityCondition;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.event.common.EntityFireImmuneEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public record FireImmunityPower(EntityCondition condition) implements Power
{
    public static final MapCodec<FireImmunityPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EntityCondition.optionalCodec("condition").forGetter(FireImmunityPower::condition)).apply((Applicative)i, FireImmunityPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void enableFireImmune(EntityFireImmuneEvent event) {
        Object entity = event.getEntity();
        for (FireImmunityPower power : EntityOriginAttachment.get(entity).getPowers(RegularPowers.FIRE_IMMUNITY, FireImmunityPower.class)) {
            if (!power.condition.test((Entity)entity)) continue;
            event.allow();
        }
    }
}

