/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.DamageCondition;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public record InvulnerabilityPower(DamageCondition condition) implements Power
{
    public static final MapCodec<InvulnerabilityPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)DamageCondition.CODEC.fieldOf("damage_condition").forGetter(InvulnerabilityPower::condition)).apply((Applicative)i, InvulnerabilityPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void handleInvulnerability(EntityInvulnerabilityCheckEvent event) {
        Entity entity = event.getEntity();
        for (InvulnerabilityPower power : EntityOriginAttachment.get(entity).getPowers(RegularPowers.INVULNERABILITY, InvulnerabilityPower.class)) {
            if (!power.condition.test(event.getSource(), 1.0f)) continue;
            event.setInvulnerable(true);
        }
    }
}

