/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.EntityCondition;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.event.client.NightVisionStrengthEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public record NightVisionPower(float strength, EntityCondition condition) implements Power
{
    public static final MapCodec<NightVisionPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("strength", (Object)Float.valueOf(1.0f)).forGetter(NightVisionPower::strength), (App)EntityCondition.optionalCodec("condition").forGetter(NightVisionPower::condition)).apply((Applicative)i, NightVisionPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void handleNightVisionStrength(NightVisionStrengthEvent event) {
        LivingEntity entity = event.getEntity();
        for (NightVisionPower power : EntityOriginAttachment.get((Entity)entity).getPowers(RegularPowers.NIGHT_VISION, NightVisionPower.class)) {
            if (!power.condition.test((Entity)entity)) continue;
            event.setStrength(power.strength);
            break;
        }
    }
}

