/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.BiEntityCondition;
import com.iafenvoy.origins.data.condition.EntityCondition;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.event.client.ClientGlowingColorEvent;
import com.iafenvoy.origins.event.client.ClientShouldGlowingEvent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public record SelfGlowPower(EntityCondition entityCondition, BiEntityCondition biEntityCondition, boolean useTeam, int color) implements Power
{
    public static final MapCodec<SelfGlowPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)EntityCondition.optionalCodec("entity_condition").forGetter(SelfGlowPower::entityCondition), (App)BiEntityCondition.optionalCodec("bientity_condition").forGetter(SelfGlowPower::biEntityCondition), (App)Codec.BOOL.optionalFieldOf("use_teams", (Object)true).forGetter(SelfGlowPower::useTeam), (App)Codec.INT.optionalFieldOf("color", (Object)-1).forGetter(SelfGlowPower::color)).apply((Applicative)i, SelfGlowPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void handleGlowingColor(ClientGlowingColorEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Entity entity = event.getEntity();
        if (player != null) {
            for (SelfGlowPower power : EntityOriginAttachment.get(entity).getPowers(RegularPowers.SELF_GLOW, SelfGlowPower.class)) {
                if (power.useTeam || !power.entityCondition.test((Entity)player) || !power.biEntityCondition.test(entity, (Entity)player)) continue;
                event.setColor(power.color);
            }
        }
    }

    @SubscribeEvent
    public static void enableGlowing(ClientShouldGlowingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        Object entity = event.getEntity();
        if (player != null) {
            for (SelfGlowPower power : EntityOriginAttachment.get(entity).getPowers(RegularPowers.SELF_GLOW, SelfGlowPower.class)) {
                if (power.useTeam || !power.entityCondition.test((Entity)player) || !power.biEntityCondition.test((Entity)entity, (Entity)player)) continue;
                event.allow();
            }
        }
    }
}

