/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.data.power.builtin.regular;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.condition.ItemCondition;
import com.iafenvoy.origins.data.power.Power;
import com.iafenvoy.origins.data.power.builtin.RegularPowers;
import com.iafenvoy.origins.util.codec.CombinedCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(value={Dist.CLIENT})
public record TooltipPower(ItemCondition itemCondition, List<Component> text, int order) implements Power
{
    public static final MapCodec<TooltipPower> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ItemCondition.optionalCodec("item_condition").forGetter(TooltipPower::itemCondition), (App)CombinedCodecs.TEXT.fieldOf("text").forGetter(TooltipPower::text), (App)Codec.INT.optionalFieldOf("order", (Object)0).forGetter(TooltipPower::order)).apply((Applicative)i, TooltipPower::new));

    @Override
    @NotNull
    public MapCodec<? extends Power> codec() {
        return CODEC;
    }

    @SubscribeEvent
    public static void appendTooltips(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player != null) {
            for (TooltipPower power : EntityOriginAttachment.get((Entity)player).getPowers(RegularPowers.TOOLTIP, TooltipPower.class)) {
                if (!power.itemCondition.test(player.level(), event.getItemStack())) continue;
                event.getToolTip().addAll(power.order, power.text);
            }
        }
    }
}

