/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.item;

import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.network.LoginHelper;
import com.iafenvoy.origins.registry.OriginsDataComponents;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OrbOfOriginItem
extends Item {
    public OrbOfOriginItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).component(OriginsDataComponents.ORB_LAYERS, List.of()));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            List layers = (List)stack.getOrDefault(OriginsDataComponents.ORB_LAYERS, List.of());
            if (layers.isEmpty()) {
                LoginHelper.openGuiForLayer(serverPlayer, null);
            } else {
                for (Holder layer : layers) {
                    LoginHelper.openGuiForLayer(serverPlayer, (Holder<Layer>)layer);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }
}

