/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.mixin.power;

import com.iafenvoy.origins.event.client.ClientGlowingColorEvent;
import com.iafenvoy.origins.event.common.EntityFireImmuneEvent;
import java.util.OptionalInt;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Entity.class})
public class EntityMixin {
    @Unique
    private Entity origins$self() {
        return (Entity)this;
    }

    @Inject(method={"getTeamColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleGlowColor(CallbackInfoReturnable<Integer> cir) {
        OptionalInt color = ((ClientGlowingColorEvent)NeoForge.EVENT_BUS.post((Event)new ClientGlowingColorEvent(this.origins$self()))).getColor();
        if (color.isPresent()) {
            cir.setReturnValue((Object)color.getAsInt());
        }
    }

    @Inject(method={"fireImmune"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleFireImmune(CallbackInfoReturnable<Boolean> cir) {
        if (((EntityFireImmuneEvent)NeoForge.EVENT_BUS.post((Event)new EntityFireImmuneEvent(this.origins$self()))).getResult().allow()) {
            cir.setReturnValue((Object)true);
        }
    }
}

