/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.mixin.power;

import com.iafenvoy.origins.event.client.NightVisionStrengthEvent;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Unique
    @NotNull
    private static Optional<Float> NIGHT_VISION_STRENGTH = Optional.empty();

    @ModifyExpressionValue(method={"setupColor"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal=0)})
    private static boolean handleNightVisionStrength1(boolean original, @Local LivingEntity living) {
        NIGHT_VISION_STRENGTH = ((NightVisionStrengthEvent)NeoForge.EVENT_BUS.post((Event)new NightVisionStrengthEvent(living))).getStrength();
        return original || NIGHT_VISION_STRENGTH.isPresent();
    }

    @ModifyExpressionValue(method={"setupColor"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;getNightVisionScale(Lnet/minecraft/world/entity/LivingEntity;F)F")})
    private static float handleNightVisionStrength2(float original) {
        return NIGHT_VISION_STRENGTH.orElse(Float.valueOf(original)).floatValue();
    }
}

