/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.mixin.power;

import com.iafenvoy.origins.event.client.ClientShouldGlowingEvent;
import com.iafenvoy.origins.event.common.CanFlyWithoutElytraEvent;
import com.iafenvoy.origins.event.common.EntityFrozenEvent;
import com.iafenvoy.origins.event.common.IgnoreWaterEvent;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private LivingEntity origins$self() {
        return (LivingEntity)this;
    }

    @ModifyExpressionValue(method={"updateFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack handleElytra(ItemStack original) {
        Player player;
        LivingEntity livingEntity = this.origins$self();
        return livingEntity instanceof Player && ((CanFlyWithoutElytraEvent)NeoForge.EVENT_BUS.post((Event)new CanFlyWithoutElytraEvent(player = (Player)livingEntity))).getResult().allow() ? Items.ELYTRA.getDefaultInstance() : original;
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleGlowing(CallbackInfoReturnable<Boolean> cir) {
        if (((ClientShouldGlowingEvent)NeoForge.EVENT_BUS.post((Event)new ClientShouldGlowingEvent(this.origins$self()))).getResult().allow()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getTicksFrozen()I")})
    private void handleFrozen(CallbackInfo ci) {
        if (((EntityFrozenEvent)NeoForge.EVENT_BUS.post((Event)new EntityFrozenEvent((Entity)this.origins$self()))).getResult().allow()) {
            this.isInPowderSnow = true;
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getAttributeValue(Lnet/minecraft/core/Holder;)D", ordinal=0)})
    private double handleSpeedInWater(double original) {
        return ((IgnoreWaterEvent)NeoForge.EVENT_BUS.post((Event)new IgnoreWaterEvent(this.origins$self()))).getResult().allow() ? 1.0 : original;
    }
}

