/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.network;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.layer.LayerRegistries;
import com.iafenvoy.origins.network.payload.ConfirmOriginS2CPayload;
import com.iafenvoy.origins.network.payload.OpenChooseOriginScreenS2CPayload;
import com.iafenvoy.origins.screen.ChooseOriginScreen;
import com.iafenvoy.origins.screen.WaitForNextLayerScreen;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class ClientNetworkHandler {
    public static void onOriginConfirm(ConfirmOriginS2CPayload packet, IPayloadContext context) {
        Player player = context.player();
        EntityOriginAttachment component = EntityOriginAttachment.get((Entity)player);
        component.setOrigin(packet.layer(), packet.origin(), (Entity)player);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof WaitForNextLayerScreen) {
            WaitForNextLayerScreen nextLayerScreen = (WaitForNextLayerScreen)screen;
            nextLayerScreen.openSelection();
        }
    }

    public static void openOriginScreen(OpenChooseOriginScreenS2CPayload packet, IPayloadContext context) {
        EntityOriginAttachment component = EntityOriginAttachment.get((Entity)context.player());
        List<Holder<Layer>> layers = LayerRegistries.streamAvailableLayers(context.player().registryAccess()).filter(x -> !component.hasOrigin((Holder<Layer>)x)).sorted(Comparator.comparing(Holder::value)).toList();
        Minecraft.getInstance().setScreen((Screen)new ChooseOriginScreen(layers, 0, packet.showBackground()));
    }
}

