/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.network;

import carpet.patches.EntityPlayerMPFake;
import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.layer.LayerRegistries;
import com.iafenvoy.origins.data.origin.OriginRegistries;
import com.iafenvoy.origins.network.payload.OpenChooseOriginScreenS2CPayload;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public final class LoginHelper {
    @SubscribeEvent
    public static void onSyncDatapack(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            LoginHelper.forEachPlayer(event.getPlayer(), false);
        } else {
            for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                LoginHelper.forEachPlayer(player, true);
            }
        }
    }

    private static void forEachPlayer(@NotNull ServerPlayer player, boolean joined) {
        EntityOriginAttachment component = EntityOriginAttachment.get((Entity)player);
        component.sync((Entity)player);
        if (component.hasAllOrigins(player.registryAccess())) {
            component.refreshPowerMap();
            return;
        }
        component.fillAutoChoosing((Entity)player);
        if (!component.hasAllOrigins(player.registryAccess()) && !LoginHelper.isFakePlayer(player)) {
            component.setSelecting(true);
            component.sync((Entity)player);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenChooseOriginScreenS2CPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        component.sync((Entity)player);
    }

    private static boolean isFakePlayer(ServerPlayer player) {
        return ModList.get().isLoaded("bedsheet") && player instanceof EntityPlayerMPFake;
    }

    public static void openGuiForLayer(ServerPlayer target, @Nullable Holder<Layer> layer) {
        EntityOriginAttachment attachment = EntityOriginAttachment.get((Entity)target);
        ObjectArrayList layers = new ObjectArrayList();
        Optional.ofNullable(layer).ifPresentOrElse(((List)layers)::add, () -> LoginHelper.lambda$openGuiForLayer$0((List)layers, target));
        layers.stream().filter(x -> ((Layer)x.value()).enabled()).forEach(l -> attachment.clearOrigin((Holder<Layer>)l, (Entity)target));
        boolean automaticallyAssigned = attachment.fillAutoChoosing((Entity)target);
        int options = Optional.ofNullable(layer).map(l -> ((Layer)l.value()).getOriginOptionCount(target.registryAccess())).orElseGet(() -> OriginRegistries.streamAvailableOrigins(target.registryAccess()).toList().size());
        attachment.setSelecting(!automaticallyAssigned || options > 0);
        attachment.sync((Entity)target);
        if (attachment.isSelecting()) {
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new OpenChooseOriginScreenS2CPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static /* synthetic */ void lambda$openGuiForLayer$0(List layers, ServerPlayer target) {
        layers.addAll(LayerRegistries.streamAvailableLayers(target.registryAccess()).toList());
    }
}

