/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.network;

import com.iafenvoy.origins.Origins;
import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.network.payload.ChooseOriginC2SPayload;
import com.iafenvoy.origins.network.payload.ConfirmOriginS2CPayload;
import com.iafenvoy.origins.util.RLHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class ServerNetworkHandler {
    public static void onChooseOrigin(ChooseOriginC2SPayload packet, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        EntityOriginAttachment component = EntityOriginAttachment.get((Entity)player2);
        Holder<Layer> layer = packet.layer();
        if (component.hasOrigin(layer)) {
            Origins.LOGGER.warn("Player {} tried to choose origin for layer \"{}\" while having one already.", (Object)player2.getName().getString(), (Object)RLHelper.string(layer));
            return;
        }
        Optional<Holder<Origin>> optional = packet.origin();
        if (optional.isPresent()) {
            Holder<Origin> origin = optional.get();
            if (((Origin)origin.value()).unchoosable() || !origin.is(((Layer)layer.value()).origins())) {
                Origins.LOGGER.warn("Player {} tried to choose unchoosable origin \"{}\" from layer \"{}\"!", new Object[]{player2.getName().getString(), RLHelper.string(origin), RLHelper.string(layer)});
                component.clearOrigin(layer, (Entity)player2);
            } else {
                component.setOrigin(layer, origin, (Entity)player2);
                Origins.LOGGER.info("Player {} chose origin \"{}\" for layer \"{}\"", new Object[]{player2.getName().getString(), RLHelper.string(origin), RLHelper.string(layer)});
            }
        } else {
            List<Holder<Origin>> randomOriginIds = ((Layer)layer.value()).collectRandomizableOrigins(player2.registryAccess()).toList();
            if (!((Layer)layer.value()).allowRandom() || randomOriginIds.isEmpty()) {
                Origins.LOGGER.warn("Player {} tried to choose a random origin for layer \"{}\", which is not allowed!", (Object)player2.getName().getString(), (Object)RLHelper.string(layer));
                component.clearOrigin(layer, (Entity)player2);
            } else {
                Holder<Origin> origin = randomOriginIds.get(player2.getRandom().nextInt(randomOriginIds.size()));
                component.setOrigin(layer, origin, (Entity)player2);
                Origins.LOGGER.info("Player {} was randomly assigned the following origin: {}", (Object)player2.getName().getString(), (Object)RLHelper.string(origin));
            }
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new ConfirmOriginS2CPayload(layer, component.getOrigin(layer)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        component.setSelecting(false);
        component.sync((Entity)player2);
    }
}

