/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.screen;

import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.origin.Impact;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.network.payload.ChooseOriginC2SPayload;
import com.iafenvoy.origins.registry.OriginsItems;
import com.iafenvoy.origins.screen.OriginDisplayScreen;
import com.iafenvoy.origins.screen.WaitForNextLayerScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ChooseOriginScreen
extends OriginDisplayScreen {
    private final List<Holder<Layer>> layers;
    private final List<Holder<Origin>> origins;
    private final int currentLayerIndex;
    private Holder<Origin> randomOrigin;
    private int currentOriginIndex = 0;
    private int maxSelection = 0;
    private static final ResourceLocation ORIGINS_CHOICES = ResourceLocation.fromNamespaceAndPath((String)"origins", (String)"textures/gui/origin_choices.png");
    private static final int CHOICES_WIDTH = 219;
    private static final int CHOICES_HEIGHT = 182;
    private static final int ORIGIN_ICON_SIZE = 26;
    private int calculatedTop;
    private int calculatedLeft;
    private int currentPage = 0;
    private static final int COUNT_PER_PAGE = 35;
    private int pages;
    private float tickTime = 0.0f;

    public ChooseOriginScreen(List<Holder<Layer>> layers, int currentLayerIndex, boolean showDirtBackground) {
        super((Component)Component.empty(), showDirtBackground);
        this.layers = layers;
        this.currentLayerIndex = currentLayerIndex;
        this.origins = new ArrayList<Holder<Origin>>(layers.size());
        this.initRandomOrigin();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            Layer currentLayer = (Layer)this.getCurrentLayer().value();
            currentLayer.collectOrigins(player.registryAccess()).forEach(arg_0 -> this.lambda$new$0((Player)player, arg_0));
            this.origins.sort(Comparator.comparingInt(o -> ((Origin)o.value()).impact().getImpactValue()).thenComparingInt(x -> ((Origin)x.value()).order()));
            this.maxSelection = currentLayer.getOriginOptionCount(player.registryAccess());
            if (this.maxSelection == 0) {
                this.openNextLayerScreen();
            }
            Holder<Origin> newOrigin = this.getCurrentOrigin();
            this.showOrigin(newOrigin, this.getCurrentLayer(), Objects.equals(newOrigin.getKey(), this.randomOrigin.getKey()));
        }
    }

    private void openNextLayerScreen() {
        Minecraft.getInstance().setScreen((Screen)new WaitForNextLayerScreen(this.layers, this.currentLayerIndex, this.showDirtBackground));
    }

    private void initRandomOrigin() {
        this.randomOrigin = Holder.direct((Object)Origin.special(OriginsItems.ORB_OF_ORIGIN.toStack(), Impact.NONE, -1));
        MutableComponent randomOriginText = Component.empty();
        ((Layer)this.layers.get(this.currentLayerIndex).value()).collectRandomizableOrigins(Minecraft.getInstance().player.registryAccess()).sorted((ia, ib) -> {
            Origin a = (Origin)ia.value();
            Origin b = (Origin)ib.value();
            int impactDelta = Integer.compare(a.impact().getImpactValue(), b.impact().getImpactValue());
            return impactDelta != 0 ? impactDelta : Integer.compare(a.order(), b.order());
        }).forEach(origin -> {
            randomOriginText.append((Component)Origin.getName((Holder<Origin>)origin));
            randomOriginText.append((Component)Component.literal((String)"\n"));
        });
        this.setRandomOriginText((Component)randomOriginText);
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"origins.gui.choose_origin.title", (Object[])new Object[]{Layer.getName(this.getCurrentLayer())});
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.calculatedTop = (this.height - 182) / 2;
        this.calculatedLeft = (this.width - 405) / 2;
        this.guiTop = (this.height - 182) / 2;
        this.guiLeft = this.calculatedLeft + 219 + 10;
        this.pages = (int)Math.ceil(1.0 * (double)this.maxSelection / 35.0);
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < Math.min(this.maxSelection, 35)) {
            if (x > 6) {
                x = 0;
                ++y;
            }
            int actualX = 12 + x * 28 + this.calculatedLeft;
            int actualY = 10 + y * 30 + this.calculatedTop;
            int finalI = i++;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> {
                int index = finalI + this.currentPage * 35;
                if (index <= this.maxSelection - 1) {
                    Holder<Origin> newOrigin;
                    this.currentOriginIndex = index;
                    this.showOrigin(newOrigin, this.layers.get(this.currentLayerIndex), (newOrigin = this.getCurrentOrigin()) == this.randomOrigin);
                }
            }).pos(actualX, actualY).size(26, 26).build());
            ++x;
        }
        if (this.maxSelection > 35) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), b -> {
                --this.currentPage;
                if (this.currentPage < 0) {
                    this.currentPage = this.pages - 1;
                }
            }).pos(this.calculatedLeft, this.guiTop + 182 + 5).size(20, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), b -> {
                this.currentPage = (this.currentPage + 1) % this.pages;
            }).pos(this.calculatedLeft + 219 - 20, this.guiTop + 182 + 5).size(20, 20).build());
        }
        if (this.maxSelection > 0) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"origins.gui.select"), button -> {
                if (this.currentOriginIndex == this.origins.size()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChooseOriginC2SPayload(this.getCurrentLayer(), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChooseOriginC2SPayload(this.getCurrentLayer(), Optional.of(super.getCurrentOrigin())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.openNextLayerScreen();
            }).bounds(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).build());
        }
    }

    @Override
    public Holder<Layer> getCurrentLayer() {
        return this.layers.get(this.currentLayerIndex);
    }

    @Override
    public Holder<Origin> getCurrentOrigin() {
        if (this.currentOriginIndex == this.origins.size()) {
            return this.randomOrigin;
        }
        return this.origins.get(this.currentOriginIndex);
    }

    @Override
    public ResourceLocation getCurrentOriginId() {
        return Objects.equals(this.getCurrentOrigin(), this.randomOrigin) ? ResourceLocation.fromNamespaceAndPath((String)"origins", (String)"random") : super.getCurrentOriginId();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
        } else {
            super.render(graphics, mouseX, mouseY, delta);
        }
        this.renderOriginChoicesBox(graphics, mouseX, mouseY, delta);
        this.tickTime += delta;
    }

    public void renderOriginChoicesBox(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        graphics.blit(ORIGINS_CHOICES, this.calculatedLeft, this.calculatedTop, 0, 0, 219, 182);
        int x = 0;
        int y = 0;
        for (int i = this.currentPage * 35; i < Math.min((this.currentPage + 1) * 35, this.maxSelection); ++i) {
            if (x > 6) {
                x = 0;
                ++y;
            }
            int actualX = 12 + x * 28 + this.calculatedLeft;
            int actualY = 10 + y * 30 + this.calculatedTop;
            if (i >= this.origins.size()) {
                boolean selected = this.getCurrentOrigin().equals(this.randomOrigin);
                this.renderRandomOrigin(graphics, mouseX, mouseY, delta, actualX, actualY, selected);
            } else {
                Holder<Origin> origin = this.origins.get(i);
                boolean selected = Objects.equals(origin.getKey(), this.getCurrentOrigin().getKey());
                this.renderOriginWidget(graphics, mouseX, mouseY, delta, actualX, actualY, selected, origin);
                graphics.renderItem(((Origin)origin.value()).icon().orElse(ItemStack.EMPTY), actualX + 5, actualY + 5);
            }
            ++x;
        }
        Font var10001 = this.font;
        int var10002 = this.currentPage + 1;
        FormattedCharSequence var13 = Component.literal((String)(var10002 + "/" + this.pages)).getVisualOrderText();
        int var10003 = this.calculatedLeft + 109;
        int var10004 = this.guiTop + 182 + 5;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(var10001, var13, var10003, var10004 + 4, 0xFFFFFF);
    }

    public void renderOriginWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta, int x, int y, boolean selected, Holder<Origin> origin) {
        Button buttonWidget;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ORIGINS_CHOICES);
        boolean mouseHovering = mouseX >= x && mouseY >= y && mouseX < x + 26 && mouseY < y + 26;
        GuiEventListener var13 = this.getFocused();
        boolean guiSelected = var13 instanceof Button && (buttonWidget = (Button)var13).getX() == x && (buttonWidget.getY() == y || mouseHovering);
        int u = (selected ? 26 : 0) + (guiSelected ? 52 : 0);
        graphics.blit(ORIGINS_CHOICES, x, y, 230, u, 26, 26);
        Impact impact = ((Origin)origin.value()).impact();
        switch (impact.name()) {
            case "NONE": {
                graphics.blit(ORIGINS_CHOICES, x, y, 224, guiSelected ? 112 : 104, 8, 8);
                break;
            }
            case "LOW": {
                graphics.blit(ORIGINS_CHOICES, x, y, 232, guiSelected ? 112 : 104, 8, 8);
                break;
            }
            case "MEDIUM": {
                graphics.blit(ORIGINS_CHOICES, x, y, 240, guiSelected ? 112 : 104, 8, 8);
                break;
            }
            case "HIGH": {
                graphics.blit(ORIGINS_CHOICES, x, y, 248, guiSelected ? 112 : 104, 8, 8);
                break;
            }
            case "VERY_HIGH": {
                graphics.blit(ORIGINS_CHOICES, x, y, 248, guiSelected ? 144 : 136, 8, 8);
                break;
            }
            default: {
                graphics.blit(ORIGINS_CHOICES, x, y, 240, guiSelected ? 144 : 136, 8, 8);
            }
        }
        if (mouseHovering) {
            MutableComponent text = Layer.getName(this.getCurrentLayer()).copy().append(": ").append((Component)Origin.getName(origin));
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }

    public void renderRandomOrigin(GuiGraphics graphics, int mouseX, int mouseY, float delta, int x, int y, boolean selected) {
        Button buttonWidget;
        boolean mouseHovering = mouseX >= x && mouseY >= y && mouseX < x + 26 && mouseY < y + 26;
        GuiEventListener var12 = this.getFocused();
        boolean guiSelected = var12 instanceof Button && (buttonWidget = (Button)var12).getX() == x && (buttonWidget.getY() == y || mouseHovering);
        int u = (selected ? 26 : 0) + (guiSelected ? 52 : 0);
        graphics.blit(ORIGINS_CHOICES, x, y, 230, u, 26, 26);
        graphics.blit(ORIGINS_CHOICES, x + 6, y + 5, 243, 120, 13, 16);
        int impact = (int)((double)this.tickTime / 15.0) % 4;
        graphics.blit(ORIGINS_CHOICES, x, y, 224 + impact * 8, guiSelected ? 112 : 104, 8, 8);
    }

    private /* synthetic */ void lambda$new$0(Player player, Holder holder) {
        if (((Origin)holder.value()).choosable()) {
            ItemStack iconStack = ((Origin)holder.value()).icon().orElse(ItemStack.EMPTY);
            if (iconStack.is(Items.PLAYER_HEAD) && !iconStack.has(DataComponents.PROFILE)) {
                iconStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
            }
            this.origins.add((Holder<Origin>)holder);
        }
    }
}

