/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.screen;

import com.google.common.collect.Lists;
import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.data.origin.Origin;
import com.iafenvoy.origins.screen.ChooseOriginScreen;
import com.iafenvoy.origins.screen.OriginDisplayScreen;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ViewOriginScreen
extends OriginDisplayScreen {
    private final List<Pair<Holder<Layer>, Holder<Origin>>> originLayers;
    private Button chooseOriginButton;
    private int currentLayerIndex = 0;

    public ViewOriginScreen() {
        super((Component)Component.empty(), false);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            this.originLayers = new LinkedList<Pair<Holder<Layer>, Holder<Origin>>>();
            return;
        }
        Map<Holder<Layer>, Holder<Origin>> origins = EntityOriginAttachment.get((Entity)player).getOriginsView();
        this.originLayers = new LinkedList<Pair<Holder<Layer>, Holder<Origin>>>();
        origins.forEach((arg_0, arg_1) -> this.lambda$new$0((Player)player, arg_0, arg_1));
        this.originLayers.sort(Comparator.comparing(x -> (Layer)((Holder)x.getFirst()).value()));
        if (this.originLayers.isEmpty()) {
            this.showOrigin(null, null, false);
        } else {
            Pair<Holder<Layer>, Holder<Origin>> currentOriginAndLayer = this.originLayers.get(this.currentLayerIndex);
            this.showOrigin((Holder<Origin>)((Holder)currentOriginAndLayer.getSecond()), (Holder<Layer>)((Holder)currentOriginAndLayer.getFirst()), false);
        }
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"origins.gui.view_origin.title", (Object[])new Object[]{Layer.getName(this.getCurrentLayer())});
    }

    @Override
    protected void init() {
        super.init();
        Minecraft client = Minecraft.getInstance();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"origins.gui.close"), button -> client.setScreen(null)).bounds(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20).build());
        if (this.originLayers.isEmpty()) {
            return;
        }
        this.chooseOriginButton = Button.builder((Component)Component.translatable((String)"origins.gui.choose"), button -> client.setScreen((Screen)new ChooseOriginScreen(Lists.newArrayList((Object[])new Holder[]{this.getCurrentLayer()}), 0, false))).bounds(this.guiLeft + 88 - 50, this.guiTop + 182 - 40, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.chooseOriginButton);
        LocalPlayer player = client.player;
        assert (player != null);
        this.chooseOriginButton.visible = this.getCurrentOrigin().value() == Origin.EMPTY && ((Layer)this.getCurrentLayer().value()).getOriginOptionCount(player.registryAccess()) > 0;
        this.chooseOriginButton.active = this.chooseOriginButton.visible;
        if (this.originLayers.size() <= 1) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), arg_0 -> this.lambda$init$4((Player)player, arg_0)).bounds(this.guiLeft - 40, this.height / 2 - 10, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), arg_0 -> this.lambda$init$5((Player)player, arg_0)).bounds(this.guiLeft + 176 + 20, this.height / 2 - 10, 20, 20).build());
    }

    @Override
    public Holder<Layer> getCurrentLayer() {
        return (Holder)this.originLayers.get(this.currentLayerIndex).getFirst();
    }

    @Override
    public Holder<Origin> getCurrentOrigin() {
        return (Holder)this.originLayers.get(this.currentLayerIndex).getSecond();
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        if (!this.originLayers.isEmpty()) {
            return;
        }
        String translationKey = "origins.gui.view_origin.empty";
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)translationKey), this.width / 2, this.guiTop + 48, 0xFFFFFF);
    }

    private /* synthetic */ void lambda$init$5(Player player, Button button) {
        this.currentLayerIndex = (this.currentLayerIndex + 1) % this.originLayers.size();
        this.showOrigin(this.getCurrentOrigin(), this.getCurrentLayer(), false);
        this.chooseOriginButton.visible = this.getCurrentOrigin().value() == Origin.EMPTY && ((Layer)this.getCurrentLayer().value()).getOriginOptionCount(player.registryAccess()) > 0;
        this.chooseOriginButton.active = this.chooseOriginButton.visible;
    }

    private /* synthetic */ void lambda$init$4(Player player, Button button) {
        this.currentLayerIndex = (this.currentLayerIndex - 1 + this.originLayers.size()) % this.originLayers.size();
        this.showOrigin(this.getCurrentOrigin(), this.getCurrentLayer(), false);
        this.chooseOriginButton.visible = this.getCurrentOrigin().value() == Origin.EMPTY && ((Layer)this.getCurrentLayer().value()).getOriginOptionCount(player.registryAccess()) > 0;
        this.chooseOriginButton.active = this.chooseOriginButton.visible;
    }

    private /* synthetic */ void lambda$new$0(Player player, Holder layer, Holder origin) {
        ItemStack iconStack = ((Origin)origin.value()).icon().orElse(ItemStack.EMPTY);
        if (iconStack.is(Items.PLAYER_HEAD) && !iconStack.has(DataComponents.PROFILE)) {
            iconStack.set(DataComponents.PROFILE, (Object)new ResolvableProfile(player.getGameProfile()));
        }
        if (!(((Layer)layer.value()).hidden() || origin.value() == Origin.EMPTY && ((Layer)layer.value()).getOriginOptionCount(player.registryAccess()) <= 0)) {
            this.originLayers.add((Pair<Holder<Layer>, Holder<Origin>>)Pair.of((Object)layer, (Object)origin));
        }
    }
}

