/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.screen;

import com.iafenvoy.origins.attachment.EntityOriginAttachment;
import com.iafenvoy.origins.data.layer.Layer;
import com.iafenvoy.origins.screen.ChooseOriginScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WaitForNextLayerScreen
extends Screen {
    private final List<Holder<Layer>> layerList;
    private final int currentLayerIndex;
    private final boolean showDirtBackground;
    private final int maxSelection;

    public WaitForNextLayerScreen(List<Holder<Layer>> layers, int currentLayerIndex, boolean showDirtBackground) {
        super((Component)Component.empty());
        this.layerList = layers;
        this.currentLayerIndex = currentLayerIndex;
        this.showDirtBackground = showDirtBackground;
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        Holder<Layer> currentLayer = layers.get(currentLayerIndex);
        this.maxSelection = ((Layer)currentLayer.value()).getOriginOptionCount(player.registryAccess());
    }

    public void openSelection() {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            EntityOriginAttachment component = EntityOriginAttachment.get((Entity)client.player);
            for (int index = this.currentLayerIndex + 1; index < this.layerList.size(); ++index) {
                Holder<Layer> layer = this.layerList.get(index);
                if (component.hasOrigin(layer) || !((Layer)layer.value()).collectOrigins(client.player.registryAccess()).findAny().isPresent()) continue;
                client.setScreen((Screen)new ChooseOriginScreen(this.layerList, index, this.showDirtBackground));
                return;
            }
        }
        client.setScreen(null);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openSelection();
        } else {
            this.renderBackground(graphics, mouseX, mouseY, delta);
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.showDirtBackground) {
            super.renderMenuBackground(graphics);
        } else {
            super.renderBackground(graphics, mouseX, mouseY, delta);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

