/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.util;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtil;

public final class CommandHelper {
    public static void executeCommand(MinecraftServer server, String command) {
        if (server.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty((String)command)) {
            try {
                server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), command);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Execute Command Action in Origins Mod");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Command to be executed");
                crashreportcategory.setDetail("Command", (Object)command);
                throw new ReportedException(crashreport);
            }
        }
    }
}

