/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.util;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public final class LevelUtil {
    public static boolean inSnow(Level world, BlockPos ... blockPositions) {
        return Arrays.stream(blockPositions).anyMatch(blockPos -> {
            Biome biome = (Biome)world.getBiome(blockPos).value();
            return biome.getPrecipitationAt(blockPos) == Biome.Precipitation.SNOW && LevelUtil.isRainingAndExposed(world, blockPos);
        });
    }

    public static boolean inThunderstorm(Level world, BlockPos ... blockPositions) {
        return Arrays.stream(blockPositions).anyMatch(blockPos -> world.isThundering() && LevelUtil.isRainingAndExposed(world, blockPos));
    }

    private static boolean isRainingAndExposed(Level world, BlockPos blockPos) {
        return world.isRaining() && world.canSeeSky(blockPos) && world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() < blockPos.getY();
    }
}

