/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;

public enum Space {
    WORLD,
    LOCAL,
    LOCAL_HORIZONTAL,
    LOCAL_HORIZONTAL_NORMALIZED,
    VELOCITY,
    VELOCITY_NORMALIZED,
    VELOCITY_HORIZONTAL,
    VELOCITY_HORIZONTAL_NORMALIZED;


    private static Matrix3f getBaseTransformMatrixFromNormalizedDirectionVector(Vec3 vector, float yaw) {
        double xZ;
        double xX;
        double zX = 0.0;
        double zY = vector.y();
        double zZ = 0.0;
        if (Math.abs(zY) != 1.0) {
            zX = vector.x();
            zZ = vector.z();
            xX = vector.z();
            xZ = -vector.x();
            float xFactor = (float)(1.0 / Math.sqrt(xX * xX + xZ * xZ));
            xX *= (double)xFactor;
            xZ *= (double)xFactor;
        } else {
            float trigonometricYaw = -yaw * ((float)Math.PI / 180);
            xX = Mth.cos((float)trigonometricYaw);
            xZ = -Mth.sin((float)trigonometricYaw);
        }
        Matrix3f res = new Matrix3f();
        res.set(0, 0, (float)xX);
        res.set(1, 0, 0.0f);
        res.set(2, 0, (float)xZ);
        res.set(0, 1, (float)(zY * xZ));
        res.set(1, 1, (float)(zZ * xX - zX * xZ));
        res.set(2, 1, (float)(-zY * xX));
        res.set(0, 2, (float)zX);
        res.set(1, 2, (float)zY);
        res.set(2, 2, (float)zZ);
        return res;
    }

    public static void transformVectorToBase(Vec3 baseForwardVector, Vector3f vector, float baseYaw, boolean normalizeBase) {
        double baseScaleD = baseForwardVector.length();
        if (baseScaleD <= 0.007) {
            vector.zero();
        } else {
            float baseScale = (float)baseScaleD;
            Vec3 normalizedBase = baseForwardVector.normalize();
            Matrix3f transformMatrix = Space.getBaseTransformMatrixFromNormalizedDirectionVector(normalizedBase, baseYaw);
            if (!normalizeBase) {
                transformMatrix.scale(baseScale, baseScale, baseScale);
            }
            vector.mulTranspose((Matrix3fc)transformMatrix);
        }
    }

    public void toGlobal(Vector3f vector, Entity entity) {
        switch (this.ordinal()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Vec3 baseForwardVector = entity.getLookAngle();
                if (this != LOCAL) {
                    baseForwardVector = new Vec3(baseForwardVector.x(), 0.0, baseForwardVector.z());
                }
                Space.transformVectorToBase(baseForwardVector, vector, entity.getYRot(), this == LOCAL_HORIZONTAL_NORMALIZED);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Vec3 baseForwardVector = entity.getDeltaMovement();
                if (this == VELOCITY_HORIZONTAL || this == VELOCITY_HORIZONTAL_NORMALIZED) {
                    baseForwardVector = new Vec3(baseForwardVector.x(), 0.0, baseForwardVector.z());
                }
                Space.transformVectorToBase(baseForwardVector, vector, entity.getYRot(), this == VELOCITY_NORMALIZED || this == VELOCITY_HORIZONTAL_NORMALIZED);
            }
        }
    }
}

