/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.util;

import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum TextAlignment implements StringRepresentable
{
    NONE("none", (left, right, textWidth) -> null),
    LEFT("left", (left, right, textWidth) -> left - 1),
    RIGHT("right", (left, right, textWidth) -> right - textWidth + 1),
    CENTER("center", (left, right, textWidth) -> (left + right - textWidth) / 2);

    final String name;
    final PositionSupplier horizontalSupplier;

    private TextAlignment(String name, PositionSupplier horizontalSupplier) {
        this.name = name;
        this.horizontalSupplier = horizontalSupplier;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Optional<Integer> horizontal(int left, int right, int textWidth) {
        return Optional.ofNullable(this.horizontalSupplier.apply(left, right, textWidth));
    }

    @FunctionalInterface
    public static interface PositionSupplier {
        public Integer apply(int var1, int var2, int var3);
    }
}

