/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.origins.util;

import java.util.List;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public final class WeightedRandomSelector {
    private static final Random RANDOM = new Random();

    @Nullable
    public static <T extends WeightGetter> T selectRandomByWeight(List<T> holders) {
        if (holders == null || holders.isEmpty()) {
            return null;
        }
        int totalWeight = 0;
        for (WeightGetter holder : holders) {
            if (holder.weight() <= 0) continue;
            totalWeight += holder.weight();
        }
        if (totalWeight <= 0) {
            return (T)((WeightGetter)holders.get(RANDOM.nextInt(holders.size())));
        }
        int randomValue = RANDOM.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightGetter holder : holders) {
            int weight = holder.weight();
            if (weight <= 0 || randomValue >= (currentWeight += weight)) continue;
            return (T)holder;
        }
        return (T)((WeightGetter)holders.getLast());
    }

    public static interface WeightGetter {
        public int weight();
    }
}

