/*
 * Decompiled with CFR 0.152.
 */
package me.Niko.inventorySlotKeep;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class InventorySlotKeep
extends JavaPlugin
implements Listener,
TabCompleter {
    private final Map<UUID, List<String>> playerKeepSlots = new HashMap<UUID, List<String>>();
    private int costInventory;
    private int costArmor;
    private int costOffHand;
    private final String GUI_TITLE = String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "Slot Keeping Menu";
    private File dataFile;
    private FileConfiguration dataConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.costInventory = this.getConfig().getInt("inventory-slot-cost", 12);
        this.costArmor = this.getConfig().getInt("armor-slot-cost", 7);
        this.costOffHand = this.getConfig().getInt("offHand-slot-cost", 12);
        this.createDataFile();
        this.loadPlayerData();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("InventorySlotKeep enabled! Slot costs: " + this.costInventory);
        Objects.requireNonNull(this.getCommand("slotkeep")).setExecutor(this::onCommand);
        this.getCommand("slotkeep").setTabCompleter((TabCompleter)this);
    }

    public void onDisable() {
        this.savePlayerData();
    }

    private void createDataFile() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.getDataFolder().mkdirs();
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void loadPlayerData() {
        if (this.dataConfig.contains("players")) {
            for (String uuidStr : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidStr);
                List slots = this.dataConfig.getStringList("players." + uuidStr);
                this.playerKeepSlots.put(uuid, new ArrayList(slots));
            }
            this.getLogger().info("Loaded player data (" + this.playerKeepSlots.size() + " players).");
        }
    }

    private void savePlayerData() {
        this.dataConfig.set("players", null);
        for (Map.Entry<UUID, List<String>> entry : this.playerKeepSlots.entrySet()) {
            this.dataConfig.set("players." + entry.getKey().toString(), entry.getValue());
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        this.openSlotGUI(player);
        return true;
    }

    private void openSlotGUI(Player player) {
        this.playerKeepSlots.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        List<String> slots = this.playerKeepSlots.get(player.getUniqueId());
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.GUI_TITLE);
        for (int i = 0; i <= 35; ++i) {
            ChatColor costColor;
            boolean owned = slots.contains(String.valueOf(i + 1));
            String pathOwned = i < 9 ? "hotbar-slot-purchased" : "inventory-slot-purchased";
            String pathNotOwned = i < 9 ? "hotbar-slot-unpurchased" : "inventory-slot-unpurchased";
            Material mat = Material.valueOf((String)(owned ? this.getConfig().getString(pathOwned, "BLACK_STAINED_GLASS_PANE") : this.getConfig().getString(pathNotOwned, "BLACK_STAINED_GLASS_PANE")));
            ItemStack item = new ItemStack(mat);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(owned ? ChatColor.GREEN : ChatColor.AQUA) + "Slot " + (i + 1));
            int slotCost = this.costInventory;
            ChatColor chatColor = owned ? ChatColor.GREEN : (costColor = player.getLevel() >= slotCost ? ChatColor.GOLD : ChatColor.DARK_RED);
            String loreLine = owned ? String.valueOf(ChatColor.GREEN) + "Already purchased" : (player.getLevel() >= slotCost ? String.valueOf(ChatColor.AQUA) + "Click to buy" : String.valueOf(ChatColor.DARK_RED) + "Not enough XP!");
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Cost: " + String.valueOf(costColor) + slotCost + " XP", loreLine));
            item.setItemMeta(meta);
            int guiIndex = i < 9 ? 45 + i : i - 9 + 18;
            gui.setItem(guiIndex, item);
        }
        String[] armorSlots = new String[]{"Helmet", "Chestplate", "Leggings", "Boots", "OffHand"};
        int[] slotCosts = new int[]{this.costArmor, this.costArmor, this.costArmor, this.costArmor, this.costOffHand};
        int[] guiPositions = new int[]{8, 7, 6, 5, 0};
        for (int i = 0; i < armorSlots.length; ++i) {
            ChatColor costColor;
            Material mat;
            boolean owned = slots.contains(armorSlots[i]);
            String pathOwned = armorSlots[i].toLowerCase() + "-slot-purchased";
            String pathNotOwned = armorSlots[i].toLowerCase() + "-slot-unpurchased";
            try {
                mat = Material.valueOf((String)(owned ? this.getConfig().getString(pathOwned, "BLACK_STAINED_GLASS_PANE") : this.getConfig().getString(pathNotOwned, "BLACK_STAINED_GLASS_PANE")));
            }
            catch (IllegalArgumentException e) {
                mat = Material.BLACK_STAINED_GLASS_PANE;
            }
            ItemStack item = new ItemStack(mat);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(owned ? ChatColor.GREEN : ChatColor.AQUA) + armorSlots[i]);
            ChatColor chatColor = owned ? ChatColor.GREEN : (costColor = player.getLevel() >= slotCosts[i] ? ChatColor.GOLD : ChatColor.DARK_RED);
            String loreLine = owned ? String.valueOf(ChatColor.GREEN) + "Already purchased" : (player.getLevel() >= slotCosts[i] ? String.valueOf(ChatColor.AQUA) + "Click to buy" : String.valueOf(ChatColor.DARK_RED) + "Not enough XP!");
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Cost: " + String.valueOf(costColor) + slotCosts[i] + " XP", loreLine));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(meta);
            gui.setItem(guiPositions[i], item);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.GUI_TITLE)) {
            return;
        }
        event.setCancelled(true);
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = ChatColor.stripColor((String)clicked.getItemMeta().getDisplayName());
        String slotKey = name.startsWith("Slot ") ? name.replace("Slot ", "") : name;
        this.playerKeepSlots.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        List<String> slots = this.playerKeepSlots.get(player.getUniqueId());
        if (slots.contains(slotKey)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You already own this slot!");
            return;
        }
        int slotCost = slotKey.equalsIgnoreCase("Helmet") || slotKey.equalsIgnoreCase("Chestplate") || slotKey.equalsIgnoreCase("Leggings") || slotKey.equalsIgnoreCase("Boots") ? this.costArmor : (slotKey.equalsIgnoreCase("OffHand") ? this.costOffHand : this.costInventory);
        if (player.getLevel() < slotCost) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Not enough XP! Needed: " + slotCost + " XP.");
            return;
        }
        player.setLevel(player.getLevel() - slotCost);
        slots.add(slotKey);
        this.savePlayerData();
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have purchased " + String.valueOf(ChatColor.AQUA) + slotKey + String.valueOf(ChatColor.GREEN) + " for " + String.valueOf(ChatColor.GOLD) + slotCost + " XP!");
        this.openSlotGUI(player);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        ItemStack keepOffHand;
        Player player = event.getEntity();
        List slotsToKeep = this.playerKeepSlots.getOrDefault(player.getUniqueId(), Collections.emptyList());
        ItemStack[] contents = player.getInventory().getContents();
        HashMap<Integer, ItemStack> keepItems = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < contents.length; ++i) {
            int displaySlot = i + 1;
            if (!slotsToKeep.contains(String.valueOf(displaySlot)) || contents[i] == null || contents[i].getType() == Material.AIR) continue;
            keepItems.put(i, contents[i]);
            event.getDrops().remove(contents[i]);
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        HashMap<Integer, ItemStack> keepArmor = new HashMap<Integer, ItemStack>();
        String[] armorNames = new String[]{"Boots", "Leggings", "Chestplate", "Helmet"};
        for (int i = 0; i < armor.length; ++i) {
            if (!slotsToKeep.contains(armorNames[i]) || armor[i] == null || armor[i].getType() == Material.AIR) continue;
            keepArmor.put(i, armor[i]);
            event.getDrops().remove(armor[i]);
        }
        ItemStack offHand = player.getInventory().getItemInOffHand();
        ItemStack itemStack = keepOffHand = slotsToKeep.contains("OffHand") && offHand != null && offHand.getType() != Material.AIR ? offHand : null;
        if (keepOffHand != null) {
            event.getDrops().remove(offHand);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            for (Map.Entry entry : keepItems.entrySet()) {
                player.getInventory().setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
            }
            for (Map.Entry entry : keepArmor.entrySet()) {
                int idx = (Integer)entry.getKey();
                ItemStack item = (ItemStack)entry.getValue();
                switch (idx) {
                    case 0: {
                        player.getInventory().setBoots(item);
                        break;
                    }
                    case 1: {
                        player.getInventory().setLeggings(item);
                        break;
                    }
                    case 2: {
                        player.getInventory().setChestplate(item);
                        break;
                    }
                    case 3: {
                        player.getInventory().setHelmet(item);
                    }
                }
            }
            if (keepOffHand != null) {
                player.getInventory().setItemInOffHand(keepOffHand);
            }
        }, 1L);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

