/*
 * Decompiled with CFR 0.152.
 */
package com.spicymike.simpleafk;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SimpleAFK
extends JavaPlugin
implements Listener,
CommandExecutor {
    private Map<UUID, Long> lastActivity = new HashMap<UUID, Long>();
    private Set<UUID> afkPlayers = new HashSet<UUID>();
    private int afkTimeout;

    public void onEnable() {
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        this.afkTimeout = config.getInt("afk-timeout-seconds", 300);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("afk").setExecutor((CommandExecutor)this);
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID uuid = player.getUniqueId();
                    if (!SimpleAFK.this.lastActivity.containsKey(uuid)) {
                        SimpleAFK.this.lastActivity.put(uuid, now);
                        continue;
                    }
                    long last = SimpleAFK.this.lastActivity.get(uuid);
                    if (SimpleAFK.this.afkPlayers.contains(uuid) || now - last < (long)SimpleAFK.this.afkTimeout * 1000L) continue;
                    SimpleAFK.this.setAFK(player, true);
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 20L);
    }

    public void onDisable() {
        this.afkPlayers.clear();
        this.lastActivity.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.lastActivity.remove(uuid);
        this.afkPlayers.remove(uuid);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.getFrom().toVector().equals((Object)event.getTo().toVector())) {
            this.updateActivity(event.getPlayer());
        }
    }

    private void updateActivity(Player player) {
        UUID uuid = player.getUniqueId();
        this.lastActivity.put(uuid, System.currentTimeMillis());
        if (this.afkPlayers.contains(uuid)) {
            this.setAFK(player, false);
        }
    }

    private void setAFK(Player player, boolean afk) {
        UUID uuid = player.getUniqueId();
        if (afk) {
            this.afkPlayers.add(uuid);
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GRAY) + player.getName() + " is AFK"));
            player.setPlayerListName(String.valueOf(ChatColor.GRAY) + "[AFK] " + String.valueOf(ChatColor.RESET) + player.getName());
        } else {
            this.afkPlayers.remove(uuid);
            player.setPlayerListName(String.valueOf(ChatColor.RESET) + player.getName());
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.GRAY) + player.getName() + " is no longer AFK"));
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        boolean afk = !this.afkPlayers.contains(uuid);
        this.setAFK(player, afk);
        return true;
    }
}

