/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus;

import com.xxinvictus.teamshudplus.core.ModTeam;
import com.xxinvictus.teamshudplus.core.TeamDB;
import com.xxinvictus.teamshudplus.network.CommonPacketHandler;
import com.xxinvictus.teamshudplus.network.client.S2CTeamDataPacket;
import com.xxinvictus.teamshudplus.network.client.S2CTeamPlayerDataPacket;
import com.xxinvictus.teamshudplus.platform.Services;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamsHUDPlus {
    public static final String MODID = "teamshudplus";
    public static final String MOD_NAME = "TeamsHUDPlus";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"TeamsHUDPlus");

    public static void init() {
        CommonPacketHandler.registerPackets();
    }

    public static void onAdvancement(ServerPlayer player, Advancement advancement) {
        if (!Services.PLATFORM.getConfig().syncAdvancements()) {
            return;
        }
        TeamDB teamDB = TeamDB.getOrMakeDefault(player.f_8924_);
        ModTeam team = teamDB.getTeam(player);
        if (team != null) {
            team.addAdvancement(advancement);
        }
    }

    public static void playerConnect(ServerPlayer player) {
        TeamDB teamDB = TeamDB.getOrMakeDefault(player.f_8924_);
        ModTeam team = teamDB.getTeam(player);
        if (team != null) {
            team.playerOnline(player, true);
        }
        String[] teams = (String[])teamDB.getTeams().map(t -> t.name).toArray(String[]::new);
        String[] onlineTeams = (String[])teamDB.getTeams().filter(t -> t.getOnlinePlayers().stream().findAny().isPresent()).map(t -> t.name).toArray(String[]::new);
        Services.PLATFORM.sendToClient(new S2CTeamDataPacket(S2CTeamDataPacket.Type.ADD, teams), player);
        Services.PLATFORM.sendToClient(new S2CTeamDataPacket(S2CTeamDataPacket.Type.ONLINE, onlineTeams), player);
    }

    public static void playerDisconnect(ServerPlayer player) {
        TeamDB teamDB = TeamDB.getOrMakeDefault(player.f_8924_);
        ModTeam team = teamDB.getTeam(player);
        if (team != null) {
            team.playerOffline(player, true);
        }
        teamDB.m_77762_();
    }

    public static void playerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean alive) {
        TeamDB teamDB = TeamDB.getOrMakeDefault(oldPlayer.f_8924_);
        ModTeam team = teamDB.getTeam(oldPlayer);
        if (team != null) {
            team.playerOffline(oldPlayer, false);
            team.playerOnline(newPlayer, false);
        }
    }

    public static void onPlayerHealthUpdate(ServerPlayer player, float health, int hunger) {
        ModTeam team = TeamDB.getOrMakeDefault(player.f_8924_).getTeam(player);
        if (team != null) {
            List<ServerPlayer> players = team.getOnlinePlayers().stream().filter(other -> !other.equals((Object)player)).collect(Collectors.toList());
            Services.PLATFORM.sendToClients(new S2CTeamPlayerDataPacket(player, S2CTeamPlayerDataPacket.Type.UPDATE), players);
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void onServerStopped(MinecraftServer server) {
    }

    public static void onServerStarted(MinecraftServer server) {
    }
}

