/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.xxinvictus.teamshudplus.ScreenDuck;
import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import com.xxinvictus.teamshudplus.client.TeamsKeys;
import com.xxinvictus.teamshudplus.client.core.ClientTeam;
import com.xxinvictus.teamshudplus.client.core.ClientTeamDB;
import com.xxinvictus.teamshudplus.client.core.TeammateDistanceTracker;
import com.xxinvictus.teamshudplus.client.ui.hud.CompassOverlay;
import com.xxinvictus.teamshudplus.client.ui.hud.HudDragManager;
import com.xxinvictus.teamshudplus.client.ui.hud.StatusOverlay;
import com.xxinvictus.teamshudplus.client.ui.menu.TeamsLonelyScreen;
import com.xxinvictus.teamshudplus.client.ui.menu.TeamsMainScreen;
import com.xxinvictus.teamshudplus.client.ui.toast.ToastInviteSent;
import com.xxinvictus.teamshudplus.client.ui.toast.ToastInvited;
import com.xxinvictus.teamshudplus.client.ui.toast.ToastJoin;
import com.xxinvictus.teamshudplus.client.ui.toast.ToastLeave;
import com.xxinvictus.teamshudplus.client.ui.toast.ToastRequested;
import com.xxinvictus.teamshudplus.mixin.InventoryScreenAccessor;
import com.xxinvictus.teamshudplus.network.client.S2CTeamPlayerDataPacket;
import com.xxinvictus.teamshudplus.network.client.S2CTeamUpdatePacket;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class TeamsHUDPlusClient {
    public static final StatusOverlay status = new StatusOverlay();
    public static final CompassOverlay compass = new CompassOverlay();
    public static final ResourceLocation TEAMS_BUTTON_TEXTURE = TeamsHUDPlus.id("textures/gui/buttonsmall.png");

    public static void registerKeybinding(KeyMapping keyMapping) {
        Minecraft.m_91087_().f_91066_.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.m_91087_().f_91066_.f_92059_, (Object)keyMapping);
    }

    public static void registerKeybinds() {
        for (TeamsKeys.TeamsKey key : TeamsKeys.KEYS) {
            key.register();
        }
    }

    public static void clientDisconnect() {
        ClientTeam.INSTANCE.reset();
        ClientTeamDB.INSTANCE.clear();
    }

    public static void afterScreenInit(Minecraft minecraft, Screen screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            if (minecraft.f_91072_ != null && !minecraft.f_91072_.m_105290_()) {
                InventoryScreenAccessor screenAccessor = (InventoryScreenAccessor)screen;
                ((ScreenDuck)inventoryScreen).$addButton((Button)new ImageButton(screenAccessor.getX() + screenAccessor.getBackgroundWidth() - 19, screenAccessor.getY() + 4, 15, 14, 0, 0, 13, TEAMS_BUTTON_TEXTURE, button -> {
                    if (ClientTeam.INSTANCE.isInTeam()) {
                        minecraft.m_91152_((Screen)new TeamsMainScreen(minecraft.f_91080_));
                    } else {
                        minecraft.m_91152_((Screen)new TeamsLonelyScreen(minecraft.f_91080_));
                    }
                }){

                    protected boolean m_93680_(double pMouseX, double pMouseY) {
                        return this.f_93623_ && this.f_93624_ && pMouseX >= (double)this.m_252754_() && pMouseY >= (double)this.m_252907_() && pMouseX < (double)(this.m_252754_() + this.f_93618_) && pMouseY < (double)(this.m_252907_() + this.f_93619_);
                    }
                });
            }
        }
    }

    public static void endClientTick() {
        for (TeamsKeys.TeamsKey key : TeamsKeys.KEYS) {
            if (!key.keyBinding.m_90859_()) continue;
            key.onPress.execute(Minecraft.m_91087_());
        }
        TeammateDistanceTracker.tick();
    }

    public static boolean onMouseClick(double mouseX, double mouseY, int button) {
        return TeamsHUDPlusClient.onMouseClick(mouseX, mouseY, button, false);
    }

    public static boolean onMouseClick(double mouseX, double mouseY, int button, boolean alreadyScaled) {
        float compassScale;
        int compassHeight;
        int compassWidth;
        int compassY;
        int compassX;
        float statusScale;
        int statusHeight;
        int statusWidth;
        int statusY;
        int statusX;
        int scaledMouseY;
        int scaledMouseX;
        if (button != 0 || HudDragManager.isLocked()) {
            return false;
        }
        Minecraft client = Minecraft.m_91087_();
        if (alreadyScaled) {
            scaledMouseX = (int)mouseX;
            scaledMouseY = (int)mouseY;
        } else {
            scaledMouseX = (int)(mouseX * (double)client.m_91268_().m_85445_() / (double)client.m_91268_().m_85443_());
            scaledMouseY = (int)(mouseY * (double)client.m_91268_().m_85446_() / (double)client.m_91268_().m_85444_());
        }
        if (TeamsHUDPlusClient.status.enabled && ClientTeam.INSTANCE.isInTeam() && HudDragManager.isMouseOver(scaledMouseX, scaledMouseY, statusX = status.getBaseX(), statusY = status.getBaseY(), statusWidth = status.getWidth(), statusHeight = status.getHeight(), statusScale = status.getScale())) {
            HudDragManager.startDrag(HudDragManager.DragTarget.STATUS, scaledMouseX, scaledMouseY, statusX, statusY);
            return true;
        }
        if (TeamsHUDPlusClient.compass.enabled && compass.isShowing() && HudDragManager.isMouseOver(scaledMouseX, scaledMouseY, compassX = compass.getBaseX(), compassY = compass.getBaseY(), compassWidth = compass.getWidth(), compassHeight = compass.getHeight(), compassScale = compass.getScale())) {
            HudDragManager.startDrag(HudDragManager.DragTarget.COMPASS, scaledMouseX, scaledMouseY, compassX, compassY);
            return true;
        }
        return false;
    }

    public static boolean onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return TeamsHUDPlusClient.onMouseDrag(mouseX, mouseY, button, dragX, dragY, false);
    }

    public static boolean onMouseDrag(double mouseX, double mouseY, int button, double dragX, double dragY, boolean alreadyScaled) {
        int scaledMouseY;
        int scaledMouseX;
        if (!HudDragManager.isDragging()) {
            return false;
        }
        Minecraft client = Minecraft.m_91087_();
        if (alreadyScaled) {
            scaledMouseX = (int)mouseX;
            scaledMouseY = (int)mouseY;
        } else {
            scaledMouseX = (int)(mouseX * (double)client.m_91268_().m_85445_() / (double)client.m_91268_().m_85443_());
            scaledMouseY = (int)(mouseY * (double)client.m_91268_().m_85446_() / (double)client.m_91268_().m_85444_());
        }
        HudDragManager.updateDrag(scaledMouseX, scaledMouseY);
        return true;
    }

    public static boolean onMouseRelease(double mouseX, double mouseY, int button) {
        return TeamsHUDPlusClient.onMouseRelease(mouseX, mouseY, button, false);
    }

    public static boolean onMouseRelease(double mouseX, double mouseY, int button, boolean alreadyScaled) {
        if (!HudDragManager.isDragging()) {
            return false;
        }
        HudDragManager.endDrag();
        return true;
    }

    public static void handleTeamUpdatePacket(String team, String player, S2CTeamUpdatePacket.Action action, boolean isLocal) {
        switch (action) {
            case JOINED: {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastJoin(team, player, isLocal));
                break;
            }
            case LEFT: {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastLeave(team, player, isLocal));
            }
        }
    }

    public static void handleTeamRequestedPacket(String name, UUID id) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastRequested(ClientTeam.INSTANCE.getName(), name, id));
    }

    public static void handleTeamInviteSentPacket(String team, String player) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastInviteSent(team, player));
    }

    public static void handleTeamPlayerDataPacket(CompoundTag tag) {
        S2CTeamPlayerDataPacket.Type type;
        UUID uuid = tag.m_128342_("playerUuid");
        try {
            type = S2CTeamPlayerDataPacket.Type.valueOf(tag.m_128461_("actionType"));
        }
        catch (IllegalArgumentException e) {
            TeamsHUDPlus.LOGGER.error("Invalid player data packet type: {}", (Object)tag.m_128461_("actionType"));
            return;
        }
        switch (type) {
            case ADD: {
                if (ClientTeam.INSTANCE.hasPlayer(uuid)) {
                    return;
                }
                String name = tag.m_128461_("playerName");
                float health = tag.m_128457_("playerHealth");
                int hunger = tag.m_128451_("playerHunger");
                String skinVal = tag.m_128461_("playerSkin");
                String skinSig = tag.m_128461_("playerSkinSignature");
                if (!skinVal.isEmpty()) {
                    GameProfile dummy = new GameProfile(UUID.randomUUID(), "");
                    dummy.getProperties().put((Object)"textures", (Object)new Property("textures", skinVal, skinSig));
                    Minecraft.m_91087_().m_91109_().m_118817_(dummy, (textureType, id, texture) -> {
                        if (textureType == MinecraftProfileTexture.Type.SKIN) {
                            ClientTeam.INSTANCE.addPlayer(uuid, name, id, health, hunger);
                        }
                    }, false);
                    break;
                }
                ClientTeam.INSTANCE.addPlayer(uuid, name, DefaultPlayerSkin.m_118627_((UUID)uuid), health, hunger);
                break;
            }
            case UPDATE: {
                float health = tag.m_128457_("playerHealth");
                int hunger = tag.m_128451_("playerHunger");
                ClientTeam.INSTANCE.updatePlayer(uuid, health, hunger);
                break;
            }
            case REMOVE: {
                ClientTeam.INSTANCE.removePlayer(uuid);
            }
        }
    }

    public static void handleTeamInvitedPacket(String team) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastInvited(team));
    }
}

