/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client;

import com.xxinvictus.teamshudplus.client.TeamsHUDPlusClient;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.lwjgl.glfw.GLFW;

public class TeamsHUDPlusClientForge {
    private static boolean wasMousePressed = false;
    public static final IGuiOverlay compass = (gui, graphics, partialTick, width, height) -> TeamsHUDPlusClient.compass.render(graphics);
    public static final IGuiOverlay status = (gui, graphics, partialTick, width, height) -> TeamsHUDPlusClient.status.render(graphics);

    public static void init(IEventBus bus) {
        bus.addListener(TeamsHUDPlusClientForge::setup);
        bus.addListener(TeamsHUDPlusClientForge::registerOverlays);
        MinecraftForge.EVENT_BUS.addListener(TeamsHUDPlusClientForge::clientTick);
        MinecraftForge.EVENT_BUS.addListener(TeamsHUDPlusClientForge::clientDisconnect);
        MinecraftForge.EVENT_BUS.addListener(TeamsHUDPlusClientForge::addButton);
    }

    static void clientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        TeamsHUDPlusClient.clientDisconnect();
    }

    static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TeamsHUDPlusClient.endClientTick();
            TeamsHUDPlusClientForge.handleMouseDrag();
        }
    }

    private static void handleMouseDrag() {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91080_ != null) {
            return;
        }
        boolean isMousePressed = GLFW.glfwGetMouseButton((long)client.m_91268_().m_85439_(), (int)0) == 1;
        double[] mouseX = new double[1];
        double[] mouseY = new double[1];
        GLFW.glfwGetCursorPos((long)client.m_91268_().m_85439_(), (double[])mouseX, (double[])mouseY);
        if (isMousePressed && !wasMousePressed) {
            TeamsHUDPlusClient.onMouseClick(mouseX[0], mouseY[0], 0);
        } else if (isMousePressed && wasMousePressed) {
            TeamsHUDPlusClient.onMouseDrag(mouseX[0], mouseY[0], 0, 0.0, 0.0);
        } else if (!isMousePressed && wasMousePressed) {
            TeamsHUDPlusClient.onMouseRelease(mouseX[0], mouseY[0], 0);
        }
        wasMousePressed = isMousePressed;
    }

    static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("compass", compass);
        event.registerAboveAll("status", status);
    }

    static void addButton(ScreenEvent.Init.Post event) {
        TeamsHUDPlusClient.afterScreenInit(Minecraft.m_91087_(), event.getScreen(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    static void setup(FMLClientSetupEvent event) {
        TeamsHUDPlusClient.registerKeybinds();
    }
}

