/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client.core;

import com.xxinvictus.teamshudplus.client.core.ClientTeam;
import com.xxinvictus.teamshudplus.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;

public class TeammateDistanceTracker {
    private static int tickCounter = 0;
    private static final Minecraft client = Minecraft.m_91087_();

    public static void tick() {
        if (!Services.PLATFORM.getConfig().showTeammateDistance()) {
            return;
        }
        int updateFrequency = Services.PLATFORM.getConfig().teammateDistanceUpdateFrequency();
        if (++tickCounter >= updateFrequency) {
            tickCounter = 0;
            TeammateDistanceTracker.updateAllDistances();
        }
    }

    private static void updateAllDistances() {
        if (TeammateDistanceTracker.client.f_91074_ == null || TeammateDistanceTracker.client.f_91073_ == null) {
            return;
        }
        for (ClientTeam.Teammate teammate : ClientTeam.INSTANCE.getTeammates()) {
            if (TeammateDistanceTracker.client.f_91074_.m_20148_().equals(teammate.id)) continue;
            Player teammatePlayer = TeammateDistanceTracker.client.f_91073_.m_46003_(teammate.id);
            if (teammatePlayer != null) {
                double distance = TeammateDistanceTracker.calculateDistance((Player)TeammateDistanceTracker.client.f_91074_, teammatePlayer);
                teammate.setDistance(distance);
                continue;
            }
            teammate.setDistance(-1.0);
        }
    }

    private static double calculateDistance(Player player1, Player player2) {
        double diffX = player1.m_20182_().f_82479_ - player2.m_20182_().f_82479_;
        double diffZ = player1.m_20182_().f_82481_ - player2.m_20182_().f_82481_;
        return Math.sqrt(diffX * diffX + diffZ * diffZ);
    }

    public static void reset() {
        tickCounter = 0;
    }
}

