/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client.ui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.xxinvictus.teamshudplus.client.core.ClientTeam;
import com.xxinvictus.teamshudplus.client.ui.hud.HudDragManager;
import com.xxinvictus.teamshudplus.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CompassOverlay {
    private static final int HUD_WIDTH = 182;
    private static final int HUD_HEIGHT = 5;
    private static final int MIN_DIST = 12;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 0.4f;
    private static final float MIN_ALPHA = 0.4f;
    static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    public boolean enabled = true;
    private final Minecraft client = Minecraft.m_91087_();
    private boolean isShowing = false;
    private int baseX = 0;
    private int baseY = 0;

    public boolean isShowing() {
        return this.isShowing;
    }

    public int getBaseX() {
        return this.baseX;
    }

    public int getBaseY() {
        return this.baseY;
    }

    public int getWidth() {
        return 182;
    }

    public int getHeight() {
        return 55;
    }

    public float getScale() {
        return Services.PLATFORM.getConfig().compassOverlayScale();
    }

    public void render(GuiGraphics graphics) {
        if (!Services.PLATFORM.getConfig().enableCompassHUD() || !this.enabled) {
            this.isShowing = false;
            return;
        }
        int configX = Services.PLATFORM.getConfig().compassOverlayX();
        int configY = Services.PLATFORM.getConfig().compassOverlayY();
        float scale = Services.PLATFORM.getConfig().compassOverlayScale();
        this.baseX = configX == -1 ? (this.client.m_91268_().m_85445_() - 182) / 2 : configX;
        this.baseY = configY == -1 ? 7 : configY;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.baseX, (float)this.baseY, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        graphics.m_280168_().m_252880_((float)(-this.baseX), (float)(-this.baseY), 0.0f);
        boolean renderedAnyHead = false;
        float minScale = 1.0f;
        for (ClientTeam.Teammate teammate : ClientTeam.INSTANCE.getTeammates()) {
            Player player;
            if (this.client.f_91074_.m_20148_().equals(teammate.id) || (player = this.client.f_91073_.m_46003_(teammate.id)) == null) continue;
            double rotationHead = this.caculateRotationHead();
            float scaleFactor = this.calculateScaleFactor(player);
            if (scaleFactor < minScale) {
                minScale = scaleFactor;
            }
            double renderFactor = this.calculateRenderFactor(player, rotationHead);
            this.renderHUDHead(graphics, teammate.skin, scaleFactor, renderFactor);
            renderedAnyHead = true;
        }
        if (ClientTeam.INSTANCE.isInTeam() && !ClientTeam.INSTANCE.isTeamEmpty() && renderedAnyHead) {
            float alpha = (1.0f - minScale) * 0.6f + 0.4f;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            graphics.m_280218_(GUI_ICONS_LOCATION, this.baseX, this.baseY, 0, 74, 182, 5);
            RenderSystem.disableBlend();
            this.isShowing = true;
        } else {
            this.isShowing = false;
        }
        graphics.m_280168_().m_85849_();
        if (!HudDragManager.isLocked() && this.isShowing) {
            this.renderDragIndicator(graphics, scale);
        }
    }

    private void renderDragIndicator(GuiGraphics graphics, float scale) {
        int color = HudDragManager.getCurrentTarget() == HudDragManager.DragTarget.COMPASS ? -2013200640 : 0x44FFFFFF;
        int scaledWidth = (int)(182.0f * scale);
        int scaledHeight = (int)(55.0f * scale);
        graphics.m_280509_(this.baseX - 1, this.baseY - 1, this.baseX + scaledWidth + 1, this.baseY + scaledHeight + 1, color);
    }

    private double caculateRotationHead() {
        double rotationHead = this.client.f_91074_.m_6080_() % 360.0f;
        if (rotationHead > 180.0) {
            rotationHead -= 360.0;
        } else if (rotationHead < -180.0) {
            rotationHead = 360.0 + rotationHead;
        }
        return rotationHead;
    }

    private float calculateScaleFactor(Player player) {
        int serverMaxDist;
        int clientMaxDist;
        int maxDist;
        double diffPosX = player.m_20182_().f_82479_ - this.client.f_91074_.m_20182_().f_82479_;
        double diffPosZ = player.m_20182_().f_82481_ - this.client.f_91074_.m_20182_().f_82481_;
        double magnitude = Math.sqrt(diffPosX * diffPosX + diffPosZ * diffPosZ);
        if (magnitude >= (double)(maxDist = Math.min(clientMaxDist = Services.PLATFORM.getConfig().compassDetectionDistance(), serverMaxDist = Services.PLATFORM.getConfig().maxCompassDetectionDistance()))) {
            return 1.0f;
        }
        if (magnitude <= 12.0) {
            return 0.0f;
        }
        return (float)((magnitude - 12.0) / (double)(maxDist - 12));
    }

    private double calculateRenderFactor(Player player, double rotationHead) {
        double renderFactor;
        double diffPosX = player.m_20182_().f_82479_ - this.client.f_91074_.m_20182_().f_82479_;
        double diffPosZ = player.m_20182_().f_82481_ - this.client.f_91074_.m_20182_().f_82481_;
        double magnitude = Math.sqrt(diffPosX * diffPosX + diffPosZ * diffPosZ);
        double angle = Math.atan((diffPosZ /= magnitude) / (diffPosX /= magnitude)) * 180.0 / Math.PI + 90.0;
        if (diffPosX >= 0.0) {
            angle -= 180.0;
        }
        if ((renderFactor = (angle - rotationHead) / 180.0) > 1.0) {
            renderFactor -= 2.0;
        }
        if (renderFactor < -1.0) {
            renderFactor = 2.0 + renderFactor;
        }
        return renderFactor;
    }

    private void renderHUDHead(GuiGraphics graphics, ResourceLocation skin, float scaleFactor, double renderFactor) {
        int x = (int)((double)(this.baseX + 91 - 45) + renderFactor * 182.0 / 2.0 + 41.0);
        int y = this.baseY + 5 + 4;
        float sizeFactor = scaleFactor * 0.2f + 0.2f;
        float alphaFactor = (1.0f - scaleFactor) * 0.6f + 0.4f;
        graphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaFactor);
        graphics.m_280168_().m_85841_(sizeFactor, sizeFactor, sizeFactor);
        if (1.0 - Math.abs(renderFactor) < (double)Math.min(alphaFactor, 0.6f)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.0 - Math.abs(renderFactor))));
            graphics.m_280218_(skin, Math.round((float)x / sizeFactor), Math.round((float)y / sizeFactor), 32, 32, 32, 32);
        } else {
            graphics.m_280218_(skin, Math.round((float)x / sizeFactor), Math.round((float)y / sizeFactor), 32, 32, 32, 32);
        }
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }
}

