/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client.ui.hud;

import com.xxinvictus.teamshudplus.platform.Services;
import net.minecraft.client.Minecraft;

public class HudDragManager {
    private static DragTarget currentlyDragging = DragTarget.NONE;
    private static int dragStartX = 0;
    private static int dragStartY = 0;
    private static int elementStartX = 0;
    private static int elementStartY = 0;
    private static boolean locked = true;

    public static boolean isLocked() {
        return locked;
    }

    public static void toggleLock() {
        locked = !locked;
    }

    public static boolean isDragging() {
        return currentlyDragging != DragTarget.NONE;
    }

    public static DragTarget getCurrentTarget() {
        return currentlyDragging;
    }

    public static boolean startDrag(DragTarget target, int mouseX, int mouseY, int elementX, int elementY) {
        if (HudDragManager.isLocked() || HudDragManager.isDragging()) {
            return false;
        }
        currentlyDragging = target;
        dragStartX = mouseX;
        dragStartY = mouseY;
        elementStartX = elementX;
        elementStartY = elementY;
        return true;
    }

    public static void updateDrag(int mouseX, int mouseY) {
        if (!HudDragManager.isDragging()) {
            return;
        }
        int deltaX = mouseX - dragStartX;
        int deltaY = mouseY - dragStartY;
        int newX = elementStartX + deltaX;
        int newY = elementStartY + deltaY;
        Minecraft client = Minecraft.m_91087_();
        int screenWidth = client.m_91268_().m_85445_();
        int screenHeight = client.m_91268_().m_85446_();
        newX = Math.max(0, Math.min(newX, screenWidth - 100));
        newY = Math.max(0, Math.min(newY, screenHeight - 100));
        switch (currentlyDragging) {
            case STATUS: {
                Services.PLATFORM.getConfig().setStatusOverlayX(newX);
                Services.PLATFORM.getConfig().setStatusOverlayY(newY);
                break;
            }
            case COMPASS: {
                Services.PLATFORM.getConfig().setCompassOverlayX(newX);
                Services.PLATFORM.getConfig().setCompassOverlayY(newY);
                break;
            }
        }
    }

    public static void endDrag() {
        if (HudDragManager.isDragging()) {
            currentlyDragging = DragTarget.NONE;
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height, float scale) {
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        return mouseX >= x && mouseX <= x + scaledWidth && mouseY >= y && mouseY <= y + scaledHeight;
    }

    public static void resetPosition(DragTarget target) {
        switch (target) {
            case STATUS: {
                Services.PLATFORM.getConfig().setStatusOverlayX(-1);
                Services.PLATFORM.getConfig().setStatusOverlayY(-1);
                break;
            }
            case COMPASS: {
                Services.PLATFORM.getConfig().setCompassOverlayX(-1);
                Services.PLATFORM.getConfig().setCompassOverlayY(-1);
                break;
            }
        }
    }

    public static enum DragTarget {
        NONE,
        STATUS,
        COMPASS;

    }
}

