/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.client.ui.hud;

import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import com.xxinvictus.teamshudplus.client.core.ClientTeam;
import com.xxinvictus.teamshudplus.client.ui.hud.HudDragManager;
import com.xxinvictus.teamshudplus.core.ModComponents;
import com.xxinvictus.teamshudplus.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StatusOverlay {
    private static final ResourceLocation ICONS = TeamsHUDPlus.id("textures/gui/hudicons.png");
    private static final int OVERLAY_WIDTH = 100;
    private static final int OVERLAY_HEIGHT_PER_PLAYER = 46;
    public boolean enabled = true;
    private final Minecraft client = Minecraft.m_91087_();
    private int offsetY = 0;
    private int baseX = 0;
    private int baseY = 0;
    private int totalHeight = 0;

    public int getBaseX() {
        return this.baseX;
    }

    public int getBaseY() {
        return this.baseY;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return this.totalHeight;
    }

    public float getScale() {
        return Services.PLATFORM.getConfig().statusOverlayScale();
    }

    public void render(GuiGraphics graphics) {
        this.offsetY = 0;
        int configX = Services.PLATFORM.getConfig().statusOverlayX();
        int configY = Services.PLATFORM.getConfig().statusOverlayY();
        float scale = Services.PLATFORM.getConfig().statusOverlayScale();
        this.baseX = configX == -1 ? (int)Math.round((double)this.client.m_91268_().m_85445_() * 0.003) : configX;
        this.baseY = configY == -1 ? this.client.m_91268_().m_85446_() / 4 - 5 : configY;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)this.baseX, (float)this.baseY, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        graphics.m_280168_().m_252880_((float)(-this.baseX), (float)(-this.baseY), 0.0f);
        List<ClientTeam.Teammate> teammates = ClientTeam.INSTANCE.getTeammates();
        int shown = 0;
        for (int i = 0; i < teammates.size() && shown < 4; ++i) {
            if (this.client.f_91074_.m_20148_().equals(teammates.get((int)i).id)) continue;
            this.renderStatus(graphics, teammates.get(i));
            ++shown;
        }
        this.totalHeight = Math.max(this.offsetY, shown > 0 ? this.offsetY : 46);
        graphics.m_280168_().m_85849_();
        if (!HudDragManager.isLocked()) {
            this.renderDragIndicator(graphics, scale);
        }
    }

    private void renderDragIndicator(GuiGraphics graphics, float scale) {
        int color = HudDragManager.getCurrentTarget() == HudDragManager.DragTarget.STATUS ? -2013200640 : 0x44FFFFFF;
        int scaledWidth = (int)(100.0f * scale);
        int scaledHeight = (int)((float)this.totalHeight * scale);
        graphics.m_280509_(this.baseX - 1, this.baseY - 1, this.baseX + scaledWidth + 1, this.baseY + scaledHeight + 1, color);
    }

    private void renderStatus(GuiGraphics graphics, ClientTeam.Teammate teammate) {
        if (!Services.PLATFORM.getConfig().enableStatusHUD() || !this.enabled) {
            return;
        }
        if (teammate.getHealth() <= 0.0f) {
            return;
        }
        int posX = this.baseX;
        int posY = this.baseY + this.offsetY;
        String health = String.valueOf(Math.round(teammate.getHealth()));
        graphics.m_280218_(ICONS, posX + 20, posY, 0, 0, 9, 9);
        graphics.m_280430_(this.client.f_91062_, (Component)ModComponents.literal(health), posX + 32, posY, ChatFormatting.WHITE.m_126665_().intValue());
        if (Services.PLATFORM.getConfig().showHunger()) {
            String hunger = String.valueOf(teammate.getHunger());
            graphics.m_280218_(ICONS, posX + 46, posY, 9, 0, 9, 9);
            graphics.m_280430_(this.client.f_91062_, (Component)ModComponents.literal(hunger), posX + 58, posY, ChatFormatting.WHITE.m_126665_().intValue());
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280218_(teammate.skin, 2 * (posX + 4), 2 * posY + 8, 32, 32, 32, 32);
        graphics.m_280168_().m_85849_();
        Object nameText = teammate.name;
        if (Services.PLATFORM.getConfig().showTeammateDistance() && teammate.getDistance() >= 0.0) {
            boolean showDistance = true;
            if (Services.PLATFORM.getConfig().distanceOnlyWithinCompassRange()) {
                int compassDetectionDistance = Services.PLATFORM.getConfig().compassDetectionDistance();
                boolean bl = showDistance = teammate.getDistance() <= (double)compassDetectionDistance;
            }
            if (showDistance) {
                int distance = (int)Math.round(teammate.getDistance());
                nameText = teammate.name + " - " + distance + "m";
            }
        }
        graphics.m_280430_(this.client.f_91062_, (Component)Component.m_237113_((String)nameText), posX + 20, posY - 15, ChatFormatting.WHITE.m_126665_().intValue());
        this.offsetY += 46;
    }
}

