/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.xxinvictus.teamshudplus.command.TeamSuggestions;
import com.xxinvictus.teamshudplus.core.IHasTeam;
import com.xxinvictus.teamshudplus.core.ModComponents;
import com.xxinvictus.teamshudplus.core.ModTeam;
import com.xxinvictus.teamshudplus.core.TeamDB;
import com.xxinvictus.teamshudplus.network.client.S2CTeamInviteSentPacket;
import com.xxinvictus.teamshudplus.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class TeamCommand {
    private TeamCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"teams").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(TeamCommand::createTeam)))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(TeamCommand::invitePlayer)))).then(Commands.m_82127_((String)"leave").executes(TeamCommand::leaveTeam))).then(Commands.m_82127_((String)"kick").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(TeamCommand::kickPlayer)))).then(Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).requires(source -> source.m_6761_(3))).suggests(TeamSuggestions.TEAMS).executes(TeamCommand::removeTeam)))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests(TeamSuggestions.TEAMS).executes(TeamCommand::getTeamInfo)))).then(Commands.m_82127_((String)"list").executes(TeamCommand::listTeams)));
    }

    private static int createTeam(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = (String)ctx.getArgument("name", String.class);
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        try {
            TeamDB.getOrMakeDefault(player.f_8924_).addTeam(name, player);
        }
        catch (ModTeam.TeamException e) {
            throw new SimpleCommandExceptionType((Message)new LiteralMessage(e.getMessage())).create();
        }
        return 1;
    }

    private static int invitePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        ServerPlayer newPlayer = EntityArgument.m_91474_(ctx, (String)"player");
        ModTeam team = ((IHasTeam)player).getTeam();
        if (team == null) {
            throw new SimpleCommandExceptionType((Message)ModComponents.translatable("teamshudplus.error.notinteam", player.m_7755_().getString())).create();
        }
        try {
            TeamCommand.get(ctx).invitePlayerToTeam(newPlayer, team);
            Services.PLATFORM.sendToClient(new S2CTeamInviteSentPacket(team.m_5758_(), newPlayer.m_7755_().getString()), player);
        }
        catch (ModTeam.TeamException e) {
            throw new SimpleCommandExceptionType((Message)new LiteralMessage(e.getMessage())).create();
        }
        return 1;
    }

    private static int leaveTeam(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        try {
            TeamCommand.get(ctx).removePlayerFromTeam(player);
        }
        catch (ModTeam.TeamException e) {
            throw new SimpleCommandExceptionType((Message)new LiteralMessage(e.getMessage())).create();
        }
        return 1;
    }

    private static int kickPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer otherPlayer = EntityArgument.m_91474_(ctx, (String)"player");
        try {
            TeamCommand.get(ctx).removePlayerFromTeam(otherPlayer);
        }
        catch (ModTeam.TeamException e) {
            throw new SimpleCommandExceptionType((Message)new LiteralMessage(e.getMessage())).create();
        }
        return 1;
    }

    private static int removeTeam(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = (String)ctx.getArgument("name", String.class);
        ModTeam team = TeamDB.getOrMakeDefault(((CommandSourceStack)ctx.getSource()).m_81377_()).getTeam(name);
        if (team == null) {
            throw new SimpleCommandExceptionType((Message)ModComponents.translatable("teamshudplus.error.invalidteam", name)).create();
        }
        TeamCommand.get(ctx).removeTeam(team);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ModComponents.translatable("teamshudplus.success.remove", name), false);
        return 1;
    }

    private static int listTeams(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ModComponents.translatable("teamshudplus.success.list", new Object[0]), false);
        TeamCommand.get(ctx).getTeams().forEach(team -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ModComponents.literal(team.m_5758_()), false));
        return 1;
    }

    private static int getTeamInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String name = (String)ctx.getArgument("name", String.class);
        ModTeam team = TeamCommand.get(ctx).getTeam(name);
        if (team == null) {
            throw new SimpleCommandExceptionType((Message)ModComponents.translatable("teamshudplus.error.invalidteam", name)).create();
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ModComponents.translatable("teamshudplus.success.info", name), false);
        team.getOnlinePlayers().forEach(player -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> ((ServerPlayer)player).m_7755_(), false));
        return 1;
    }

    private static TeamDB get(CommandContext<CommandSourceStack> context) {
        return TeamDB.getOrMakeDefault(((CommandSourceStack)context.getSource()).m_81377_());
    }
}

