/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.config;

import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ConfigMigration {
    public static boolean migrateFabricConfig(Path configDir) {
        Path oldConfig = configDir.resolve("teams.json");
        Path newConfig = configDir.resolve("teamshudplus.json");
        return ConfigMigration.migrateConfigFile(oldConfig, newConfig, "Fabric");
    }

    public static boolean migrateForgeClientConfig(Path configDir) {
        Path oldConfig = configDir.resolve("teams-client.toml");
        Path newConfig = configDir.resolve("teamshudplus-client.toml");
        return ConfigMigration.migrateConfigFile(oldConfig, newConfig, "Forge Client");
    }

    public static boolean migrateForgeServerConfig(Path configDir) {
        Path oldConfigCommon = configDir.resolve("teams-common.toml");
        Path oldConfigServer = configDir.resolve("teams-server.toml");
        Path newConfig = configDir.resolve("teamshudplus-server.toml");
        Path oldConfig = Files.exists(oldConfigCommon, new LinkOption[0]) ? oldConfigCommon : oldConfigServer;
        return ConfigMigration.migrateConfigFile(oldConfig, newConfig, "Forge Server");
    }

    private static boolean migrateConfigFile(Path oldConfig, Path newConfig, String configType) {
        if (Files.exists(newConfig, new LinkOption[0])) {
            return false;
        }
        if (!Files.exists(oldConfig, new LinkOption[0])) {
            return false;
        }
        try {
            TeamsHUDPlus.LOGGER.info("Found old {} config at: {}", (Object)configType, (Object)oldConfig);
            TeamsHUDPlus.LOGGER.info("Migrating to: {}", (Object)newConfig);
            Files.copy(oldConfig, newConfig, new CopyOption[0]);
            TeamsHUDPlus.LOGGER.info("Successfully migrated {} config! Your settings have been preserved.", (Object)configType);
            TeamsHUDPlus.LOGGER.info("Note: The old config file has been kept for safety. You may delete it if migration was successful.");
            return true;
        }
        catch (Exception e) {
            TeamsHUDPlus.LOGGER.error("Failed to migrate {} config from {} to {}", new Object[]{configType, oldConfig, newConfig, e});
            TeamsHUDPlus.LOGGER.error("You may need to manually copy your settings from the old config file.");
            return false;
        }
    }

    public static Path getConfigDirectory() {
        return Paths.get("config", new String[0]);
    }
}

