/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.core;

import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class LegacyDataMigration {
    private static final String TEAMS_DATA_FILE = "teams.dat";

    public static boolean checkForLegacyData(MinecraftServer server) {
        try {
            File worldDir = server.m_129843_(LevelResource.f_78182_).toFile();
            File dataDir = new File(worldDir, "data");
            File teamsFile = new File(dataDir, TEAMS_DATA_FILE);
            if (teamsFile.exists()) {
                TeamsHUDPlus.LOGGER.info("Found existing team data at: {}", (Object)teamsFile.getAbsolutePath());
                try {
                    CompoundTag nbt = NbtIo.m_128937_((File)teamsFile);
                    if (nbt != null && nbt.m_128441_("teams")) {
                        int teamCount = nbt.m_128437_("teams", 10).size();
                        TeamsHUDPlus.LOGGER.info("Team data contains {} team(s). Data will be loaded automatically.", (Object)teamCount);
                        return true;
                    }
                    TeamsHUDPlus.LOGGER.warn("Team data file exists but appears to be empty or corrupted.");
                }
                catch (IOException e) {
                    TeamsHUDPlus.LOGGER.error("Failed to read existing team data. Migration may fail.", (Throwable)e);
                }
            } else {
                TeamsHUDPlus.LOGGER.info("No existing team data found. This is normal for new worlds.");
            }
        }
        catch (Exception e) {
            TeamsHUDPlus.LOGGER.error("Error checking for legacy data", (Throwable)e);
        }
        return false;
    }

    public static String getDataStatus(MinecraftServer server) {
        try {
            File worldDir = server.m_129843_(LevelResource.f_78182_).toFile();
            File dataDir = new File(worldDir, "data");
            File teamsFile = new File(dataDir, TEAMS_DATA_FILE);
            if (!teamsFile.exists()) {
                return "No team data file found (new world or no teams created yet)";
            }
            long fileSizeKB = teamsFile.length() / 1024L;
            String lastModified = new Date(teamsFile.lastModified()).toString();
            try {
                CompoundTag nbt = NbtIo.m_128937_((File)teamsFile);
                if (nbt != null && nbt.m_128441_("teams")) {
                    int teamCount = nbt.m_128437_("teams", 10).size();
                    return String.format("Team data: %d team(s), %dKB, last modified: %s", teamCount, fileSizeKB, lastModified);
                }
            }
            catch (IOException e) {
                return String.format("Team data file exists (%dKB) but cannot be read: %s", fileSizeKB, e.getMessage());
            }
            return String.format("Team data file exists (%dKB) but appears empty", fileSizeKB);
        }
        catch (Exception e) {
            return "Error checking team data: " + e.getMessage();
        }
    }

    public static String checkPlayerTeamData(MinecraftServer server, String playerUUID) {
        try {
            File worldDir = server.m_129843_(LevelResource.f_78182_).toFile();
            File playerDataDir = new File(worldDir, "playerdata");
            File playerFile = new File(playerDataDir, playerUUID + ".dat");
            if (!playerFile.exists()) {
                TeamsHUDPlus.LOGGER.debug("No player data file found for UUID: {}", (Object)playerUUID);
                return null;
            }
            CompoundTag nbt = NbtIo.m_128937_((File)playerFile);
            if (nbt.m_128441_("playerTeam")) {
                String teamName = nbt.m_128461_("playerTeam");
                TeamsHUDPlus.LOGGER.debug("Player {} is in team: {}", (Object)playerUUID, (Object)teamName);
                return teamName;
            }
            TeamsHUDPlus.LOGGER.debug("Player {} has no team assignment", (Object)playerUUID);
        }
        catch (Exception e) {
            TeamsHUDPlus.LOGGER.error("Error reading player team data for {}", (Object)playerUUID, (Object)e);
        }
        return null;
    }
}

