/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.mixin;

import com.mojang.authlib.GameProfile;
import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import com.xxinvictus.teamshudplus.core.IHasTeam;
import com.xxinvictus.teamshudplus.core.ModTeam;
import com.xxinvictus.teamshudplus.core.TeamDB;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements IHasTeam {
    @Shadow
    @Final
    public ServerPlayerGameMode f_8941_;
    @Unique
    private ModTeam team;

    @Shadow
    public abstract ServerLevel m_284548_();

    public ServerPlayerMixin(Level $$0, BlockPos $$1, float $$2, GameProfile $$3) {
        super($$0, $$1, $$2, $$3);
    }

    @Override
    public boolean hasTeam() {
        return this.team != null;
    }

    @Override
    public ModTeam getTeam() {
        return this.team;
    }

    @Override
    public void setTeam(ModTeam team) {
        this.team = team;
    }

    @Override
    public boolean isTeammate(ServerPlayer other) {
        if (this.team == null || other == null) {
            return false;
        }
        ModTeam otherTeam = ((IHasTeam)other).getTeam();
        if (otherTeam == null) {
            return false;
        }
        return this.team.equals((Object)otherTeam);
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo info) {
        if (this.team != null) {
            nbt.m_128359_("playerTeam", this.team.m_5758_());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo info) {
        if (this.team == null && nbt.m_128441_("playerTeam")) {
            this.team = TeamDB.getOrMakeDefault(this.m_284548_().m_7654_()).getTeam(nbt.m_128461_("playerTeam"));
            if (this.team == null || !this.team.hasPlayer(this.m_20148_())) {
                this.team = null;
            }
        }
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/server/level/ServerPlayer;getHealth()F", ordinal=1)}, method={"doTick"})
    private void playerTick(CallbackInfo info) {
        ServerPlayer player = (ServerPlayer)this;
        TeamsHUDPlus.onPlayerHealthUpdate(player, player.m_21223_(), player.m_36324_().m_38702_());
    }

    public boolean m_5833_() {
        return this.f_8941_.m_9290_() == GameType.SPECTATOR;
    }

    public boolean m_7500_() {
        return this.f_8941_.m_9290_() == GameType.CREATIVE;
    }
}

