/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.network.client;

import com.xxinvictus.teamshudplus.client.core.ClientTeamDB;
import com.xxinvictus.teamshudplus.network.client.S2CModPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class S2CTeamDataPacket
implements S2CModPacket {
    private static final String TEAM_KEY = "teamName";
    private static final String TYPE_KEY = "type";
    CompoundTag tag = new CompoundTag();

    public S2CTeamDataPacket(Type type, String ... teams) {
        ListTag nbtList = new ListTag();
        for (String team : teams) {
            nbtList.add((Object)StringTag.m_129297_((String)team));
        }
        this.tag.m_128365_(TEAM_KEY, (Tag)nbtList);
        this.tag.m_128359_(TYPE_KEY, type.name());
    }

    public S2CTeamDataPacket(FriendlyByteBuf byteBuf) {
        this.tag = byteBuf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf to) {
        to.m_130079_(this.tag);
    }

    @Override
    public void handleClient() {
        Type type = Type.valueOf(this.tag.m_128461_(TYPE_KEY));
        ListTag nbtList = this.tag.m_128437_(TEAM_KEY, 8);
        for (Tag elem : nbtList) {
            String team = elem.m_7916_();
            switch (type) {
                case ADD: {
                    ClientTeamDB.INSTANCE.addTeam(team);
                    break;
                }
                case REMOVE: {
                    ClientTeamDB.INSTANCE.removeTeam(team);
                    break;
                }
                case ONLINE: {
                    ClientTeamDB.INSTANCE.teamOnline(team);
                    break;
                }
                case OFFLINE: {
                    ClientTeamDB.INSTANCE.teamOffline(team);
                    break;
                }
                case CLEAR: {
                    ClientTeamDB.INSTANCE.clear();
                }
            }
        }
    }

    public static enum Type {
        ADD,
        REMOVE,
        ONLINE,
        OFFLINE,
        CLEAR;

    }
}

