/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.network.server;

import com.mojang.authlib.GameProfile;
import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import com.xxinvictus.teamshudplus.core.IHasTeam;
import com.xxinvictus.teamshudplus.core.ModTeam;
import com.xxinvictus.teamshudplus.core.TeamDB;
import com.xxinvictus.teamshudplus.network.server.C2SModPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class C2STeamInvitePacket
implements C2SModPacket {
    String to;

    public C2STeamInvitePacket(String to) {
        this.to = to;
    }

    public C2STeamInvitePacket(FriendlyByteBuf byteBuf) {
        this.to = byteBuf.m_130277_();
    }

    @Override
    public void write(FriendlyByteBuf to) {
        to.m_130070_(this.to);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        UUID to = ((GameProfile)player.f_8924_.m_129927_().m_10996_(this.to).orElseThrow()).getId();
        ServerPlayer toPlayer = player.f_8924_.m_6846_().m_11259_(to);
        ModTeam team = ((IHasTeam)player).getTeam();
        if (team == null) {
            TeamsHUDPlus.LOGGER.error("Player {} tried inviting {} but they are not in a team", (Object)player.m_7755_().getString(), (Object)toPlayer.m_7755_().getString());
        } else {
            try {
                TeamDB.getOrMakeDefault(player.f_8924_).invitePlayerToTeam(toPlayer, team);
            }
            catch (ModTeam.TeamException e) {
                TeamsHUDPlus.LOGGER.error("Failed to invite player {} to team '{}': {}", new Object[]{toPlayer.m_7755_().getString(), team.m_5758_(), e.getMessage(), e});
            }
        }
    }
}

