/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.network.server;

import com.xxinvictus.teamshudplus.TeamsHUDPlus;
import com.xxinvictus.teamshudplus.core.ModTeam;
import com.xxinvictus.teamshudplus.core.TeamDB;
import com.xxinvictus.teamshudplus.network.server.C2SModPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class C2STeamKickPacket
implements C2SModPacket {
    String name;
    UUID toKick;

    public C2STeamKickPacket(String team, UUID playerToKick) {
        this.name = team;
        this.toKick = playerToKick;
    }

    public C2STeamKickPacket(FriendlyByteBuf byteBuf) {
        this.name = byteBuf.m_130277_();
        this.toKick = byteBuf.m_130259_();
    }

    @Override
    public void write(FriendlyByteBuf to) {
        to.m_130070_(this.name);
        to.m_130077_(this.toKick);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ModTeam team = TeamDB.getOrMakeDefault(player.f_8924_).getTeam(this.name);
        if (player != null && team.playerHasPermissions(player)) {
            ServerPlayer kicked = player.f_8924_.m_6846_().m_11259_(this.toKick);
            try {
                TeamDB.getOrMakeDefault(player.f_8924_).removePlayerFromTeam(kicked);
            }
            catch (ModTeam.TeamException ex) {
                TeamsHUDPlus.LOGGER.error("Failed to kick player {} from team '{}': {}", new Object[]{this.toKick, this.name, ex.getMessage(), ex});
            }
        } else {
            TeamsHUDPlus.LOGGER.error("Player {} attempted to kick {} from team '{}' without permissions", new Object[]{player != null ? player.m_7755_().getString() : "null", this.toKick, this.name});
        }
    }
}

