/*
 * Decompiled with CFR 0.152.
 */
package com.xxinvictus.teamshudplus.platform.services;

import com.xxinvictus.teamshudplus.network.client.S2CModPacket;
import com.xxinvictus.teamshudplus.network.server.C2SModPacket;
import com.xxinvictus.teamshudplus.platform.MultiloaderConfig;
import com.xxinvictus.teamshudplus.platform.PhysicalSide;
import com.xxinvictus.teamshudplus.platform.Platform;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public interface IPlatformHelper {
    public Platform getPlatform();

    public PhysicalSide getPhysicalSide();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public MultiloaderConfig getConfig();

    public void sendToClient(S2CModPacket var1, ServerPlayer var2);

    default public void sendToClients(S2CModPacket msg, Collection<ServerPlayer> playerList) {
        playerList.forEach(player -> this.sendToClient(msg, (ServerPlayer)player));
    }

    public void sendToServer(C2SModPacket var1);

    public void registerKeyBinding(KeyMapping var1);

    public <MSG extends S2CModPacket> void registerClientMessage(Class<MSG> var1, Function<FriendlyByteBuf, MSG> var2);

    public <MSG extends C2SModPacket> void registerServerMessage(Class<MSG> var1, Function<FriendlyByteBuf, MSG> var2);
}

