/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import committee.nova.mods.avaritia.api.client.screen.ItemSelectScreen;
import committee.nova.mods.avaritia.api.client.screen.component.OperationButton;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.util.GuiUtils;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.StringUtils;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.common.net.C2SItemFilterPack;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ItemFilterScreen
extends Screen {
    private final int itemPerLine = 9;
    private final int maxLine = 5;
    private int bgX;
    private int bgY;
    private final double margin = 3.0;
    private double itemBgX = (double)this.bgX + 3.0;
    private double itemBgY = this.bgY + 20;
    private List<ItemStack> itemList = new ArrayList<ItemStack>();
    private final Set<TagKey<Item>> visibleTags = new HashSet<TagKey<Item>>();
    private String selectedItemId = "";
    private ItemStack currentItem = new ItemStack((ItemLike)Items.f_41852_);
    private int scrollOffset = 0;
    private double mouseDownX = -1.0;
    private double mouseDownY = -1.0;
    private double scrollOffsetOld;
    private double outScrollX;
    private double outScrollY;
    private int outScrollWidth = 5;
    private int outScrollHeight;
    private double inScrollHeight;
    private double inScrollY;
    private final Map<Integer, OperationButton> OP_BUTTONS = new HashMap<Integer, OperationButton>();
    private final List<OperationButton> ITEM_BUTTONS = new ArrayList<OperationButton>();

    private void setScrollOffset(double offset) {
        this.scrollOffset = (int)Math.max(Math.min(offset, (double)((int)Math.ceil((double)(this.itemList.size() - 45) / 9.0))), 0.0);
    }

    public ItemFilterScreen() {
        super((Component)Component.m_237113_((String)"ItemFilterScreen"));
        this.updateItems();
    }

    protected void m_7856_() {
        this.updateVisibleTags();
        this.updateLayout();
        this.m_142416_((GuiEventListener)GuiUtils.newButton((int)((double)(this.bgX + 90) + this.margin), (int)((double)this.bgY + 118.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u6dfb\u52a0", new Object[0])), button -> Minecraft.m_91087_().m_91152_((Screen)new ItemSelectScreen(this, input -> {
            NetworkHandler.CHANNEL.sendToServer((Object)new C2SItemFilterPack(0, (ItemStack)input));
            this.itemList.add((ItemStack)input);
        }, Blocks.f_50493_.m_5456_().m_7968_()))));
        this.m_142416_((GuiEventListener)GuiUtils.newButton((int)((double)this.bgX + this.margin), (int)((double)this.bgY + 118.0), (int)(90.0 - this.margin * 2.0), 20, (Component)GuiUtils.textToComponent(Text.i18n("\u5220\u9664", new Object[0])), button -> {
            this.itemList.remove(this.currentItem);
            if (this.currentItem != null) {
                NetworkHandler.CHANNEL.sendToServer((Object)new C2SItemFilterPack(1, this.currentItem));
            }
            Minecraft.m_91087_().m_91152_(null);
        }));
    }

    @ParametersAreNonnullByDefault
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        GuiUtils.fill(graphics, (int)((double)this.bgX - this.margin), (int)((double)this.bgY - this.margin), (int)(180.0 + this.margin * 2.0), 146, -859388218, 2);
        GuiUtils.fillOutLine(graphics, (int)(this.itemBgX - this.margin), (int)(this.itemBgY - this.margin), (int)((16.0 + this.margin) * (double)this.itemPerLine + this.margin), (int)((16.0 + this.margin) * (double)this.maxLine + this.margin), 1, -16777216, 1);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.renderButton(graphics, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.setScrollOffset((double)this.getScrollOffset() - delta);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.OP_BUTTONS.forEach((key, value) -> {
                if (value.isHovered()) {
                    value.setPressed(true);
                    if (key.intValue() == OperationButtonType.SLIDER.getCode()) {
                        this.scrollOffsetOld = this.getScrollOffset();
                        this.mouseDownX = mouseX;
                        this.mouseDownY = mouseY;
                    }
                }
            });
            this.ITEM_BUTTONS.forEach(bt -> bt.setPressed(bt.isHovered()));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (button == 0 || button == 1) {
            this.ITEM_BUTTONS.forEach(bt -> {
                if (bt.isHovered() && bt.isPressed()) {
                    this.handleItem((OperationButton)bt, button, flag);
                }
                bt.setPressed(false);
            });
            this.mouseDownX = -1.0;
            this.mouseDownY = -1.0;
        }
        return flag.get() ? flag.get() : super.m_6348_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.OP_BUTTONS.forEach((key, value) -> {
            value.setHovered(value.isMouseOverEx(mouseX, mouseY));
            if (key.intValue() == OperationButtonType.SLIDER.getCode() && value.isPressed() && this.mouseDownX != -1.0 && this.mouseDownY != -1.0) {
                double scale = Math.ceil((double)(this.itemList.size() - 45) / 9.0) / (double)(this.outScrollHeight - 2);
                this.setScrollOffset(this.scrollOffsetOld + (mouseY - this.mouseDownY) * scale);
            }
        });
        this.ITEM_BUTTONS.forEach(bt -> bt.setHovered(bt.isMouseOverEx(mouseX, mouseY)));
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6913_() {
        return super.m_6913_();
    }

    public boolean m_7043_() {
        return false;
    }

    private void handleItem(OperationButton bt, int button, AtomicBoolean flag) {
        if (button == 0) {
            this.selectedItemId = bt.getId();
            if (StringUtils.isNotNullOrEmpty(this.selectedItemId)) {
                this.currentItem = ItemUtils.getItemStack(this.selectedItemId);
                this.currentItem.m_41764_(1);
                flag.set(true);
            }
        }
    }

    private void updateItems() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.itemList.clear();
            CompoundTag filters = Minecraft.m_91087_().f_91074_.m_21205_().m_41784_().m_128469_("filters");
            filters.m_128431_().forEach(key -> this.itemList.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)filters.m_128423_(key)))));
        }
        this.setScrollOffset(0.0);
    }

    private void updateVisibleTags() {
        BuiltInRegistries.f_257033_.m_203613_().forEach(this.visibleTags::add);
    }

    private void updateLayout() {
        this.bgX = this.f_96543_ / 2 - 92;
        this.bgY = this.f_96544_ / 2 - 65;
        this.itemBgX = (double)this.bgX + 3.0;
        this.itemBgY = this.bgY + 20;
        this.OP_BUTTONS.put(OperationButtonType.SLIDER.getCode(), new OperationButton(OperationButtonType.SLIDER.getCode(), context -> {
            double bgWidth = 171.0;
            double bgHeight = 92.0;
            this.outScrollX = this.itemBgX + bgWidth + 2.0;
            this.outScrollY = this.itemBgY - this.margin + 1.0;
            this.outScrollWidth = 5;
            this.outScrollHeight = (int)(bgHeight + this.margin + 1.0);
            double inScrollWidthScale = this.itemList.size() > 45 ? 45.0 / (double)this.itemList.size() : 1.0;
            double outLine = Math.max((int)Math.ceil((double)(this.itemList.size() - 45) / 9.0), 0);
            double outCellHeight = outLine == 0.0 ? 0.0 : (1.0 - inScrollWidthScale) * (double)(this.outScrollHeight - 2) / outLine;
            double inScrollTopHeight = (double)this.getScrollOffset() * outCellHeight;
            this.inScrollHeight = Math.max(2.0, (double)(this.outScrollHeight - 2) * inScrollWidthScale);
            this.inScrollY = this.outScrollY + inScrollTopHeight + 1.0;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)this.outScrollY, this.outScrollWidth, this.outScrollHeight, -870112477);
            int color = context.button().isHovered() ? -855638017 : -863270005;
            GuiUtils.fill(context.graphics(), (int)this.outScrollX, (int)Math.ceil(this.inScrollY), this.outScrollWidth, (int)this.inScrollHeight, color);
            context.button().setX(this.outScrollX).setY(this.outScrollY).setWidth(this.outScrollWidth).setHeight(this.outScrollHeight);
        }));
        this.ITEM_BUTTONS.clear();
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.ITEM_BUTTONS.add(new OperationButton(9 * i + j, context -> {
                    int i1 = context.button().getOperation() / 9;
                    int j1 = context.button().getOperation() % 9;
                    int index = ((this.itemList.size() > 45 ? this.getScrollOffset() : 0) + i1) * 9 + j1;
                    if (index >= 0 && index < this.itemList.size()) {
                        ItemStack itemStack = this.itemList.get(index);
                        double itemX = this.itemBgX + (double)j1 * 19.0;
                        double itemY = this.itemBgY + (double)i1 * 19.0;
                        int bgColor = context.button().isHovered() || ItemUtils.getId(itemStack).equalsIgnoreCase(this.getSelectedItemId()) ? -293819524 : -294621072;
                        context.button().setX(itemX - 1.0).setY(itemY - 1.0).setWidth(18.0).setHeight(18.0).setId(ItemUtils.getId(itemStack));
                        GuiUtils.fill(context.graphics(), (int)context.button().getX(), (int)context.button().getY(), (int)context.button().getWidth(), (int)context.button().getHeight(), bgColor);
                        context.graphics().m_280480_(itemStack, (int)context.button().getX() + 1, (int)context.button().getY() + 1);
                        context.button().setCustomPopupFunction(() -> {
                            if (context.button().isHovered()) {
                                List list = itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                                ArrayList list1 = Lists.newArrayList((Iterable)list);
                                this.visibleTags.forEach(itemITag -> {
                                    if (itemStack.m_204117_(itemITag)) {
                                        list1.add(1, Component.m_237113_((String)("#" + itemITag.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE));
                                    }
                                });
                                for (CreativeModeTab modeTab : CreativeModeTabs.m_257478_()) {
                                    if (!modeTab.m_257694_(itemStack)) continue;
                                    list1.add(1, modeTab.m_40786_().m_6881_().m_130940_(ChatFormatting.BLUE));
                                }
                                context.graphics().renderTooltip(this.f_96547_, (List)list1, itemStack.m_150921_(), itemStack, (int)context.mouseX(), (int)context.mouseY());
                            }
                        });
                    } else {
                        context.button().setX(0.0).setY(0.0).setWidth(0.0).setHeight(0.0).setId("");
                    }
                }));
            }
        }
    }

    private void renderButton(GuiGraphics graphics, int mouseX, int mouseY) {
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.render(graphics, mouseX, mouseY);
        }
        for (OperationButton button : this.OP_BUTTONS.values()) {
            button.renderPopup(graphics, this.f_96547_, mouseX, mouseY);
        }
        for (OperationButton button : this.ITEM_BUTTONS) {
            button.renderPopup(graphics, this.f_96547_, mouseX, mouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (AvaritiaForgeClient.FILTER_KEY.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @Generated
    public String getSelectedItemId() {
        return this.selectedItemId;
    }

    @Generated
    public int getScrollOffset() {
        return this.scrollOffset;
    }

    static enum OperationButtonType {
        SLIDER(1);

        final int code;

        private OperationButtonType(int code) {
            this.code = code;
        }

        static OperationButtonType valueOf(int code) {
            return Arrays.stream(OperationButtonType.values()).filter(v -> v.getCode() == code).findFirst().orElse(null);
        }

        @Generated
        public int getCode() {
            return this.code;
        }
    }
}

