/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.screen.coordinate.Coordinate;
import committee.nova.mods.avaritia.api.client.screen.coordinate.TextureCoordinate;
import committee.nova.mods.avaritia.api.client.util.TextureUtils;
import committee.nova.mods.avaritia.api.util.DateUtils;
import committee.nova.mods.avaritia.api.util.StringUtils;
import committee.nova.mods.avaritia.api.util.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class GuiUtils {
    public static final int ITEM_ICON_SIZE = 16;
    public static final int ENTITY_ICON_SIZE = 28;

    public static void setDepth(GuiGraphics graphics) {
        GuiUtils.setDepth(graphics, EDepth.FOREGROUND);
    }

    public static void setDepth(GuiGraphics graphics, EDepth depth) {
        RenderSystem.disableDepthTest();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)depth.getDepth());
    }

    public static void resetDepth(GuiGraphics graphics) {
        graphics.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
    }

    public static void blit(GuiGraphics graphics, int x0, int y0, int z, int destWidth, int destHeight, TextureAtlasSprite sprite) {
        graphics.m_280159_(x0, y0, z, destWidth, destHeight, sprite);
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x0, int y0, int z, float u0, float v0, int width, int height, int textureHeight, int textureWidth) {
        graphics.m_280398_(texture, x0, y0, z, u0, v0, width, height, textureHeight, textureWidth);
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x0, int y0, int destWidth, int destHeight, float u0, float v0, int srcWidth, int srcHeight, int textureWidth, int textureHeight) {
        graphics.m_280411_(texture, x0, y0, destWidth, destHeight, u0, v0, srcWidth, srcHeight, textureWidth, textureHeight);
    }

    public static void blit(GuiGraphics graphics, ResourceLocation texture, int x0, int y0, float u0, float v0, int destWidth, int destHeight, int textureWidth, int textureHeight) {
        graphics.m_280163_(texture, x0, y0, u0, v0, destWidth, destHeight, textureWidth, textureHeight);
    }

    public static void renderRotatedTexture(GuiGraphics graphics, ResourceLocation texture, TextureCoordinate textureCoordinate, Coordinate coordinate, double baseX, double baseY, double scale, double angle, boolean flipHorizontal, boolean flipVertical) {
        double x = baseX + coordinate.getX() * scale;
        double y = baseY + coordinate.getY() * scale;
        int width = (int)(coordinate.getWidth() * scale);
        int height = (int)(coordinate.getHeight() * scale);
        float u0 = (float)coordinate.getU0();
        float v0 = (float)coordinate.getV0();
        int uWidth = (int)coordinate.getUWidth();
        int vHeight = (int)coordinate.getVHeight();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(x + (double)width / 2.0, y + (double)height / 2.0, 0.0);
        graphics.m_280168_().m_252781_(new Quaternionf().rotateZ((float)Math.toRadians(angle)));
        if (flipHorizontal) {
            u0 += (float)uWidth;
            uWidth = -uWidth;
        }
        if (flipVertical) {
            v0 += (float)vHeight;
            vHeight = -vHeight;
        }
        graphics.m_280168_().m_85837_((double)(-width) / 2.0, (double)(-height) / 2.0, 0.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiUtils.blit(graphics, texture, 0, 0, width, height, u0, v0, uWidth, vHeight, textureCoordinate.getTotalWidth(), textureCoordinate.getTotalHeight());
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }

    public static void renderTremblingTexture(GuiGraphics graphics, ResourceLocation texture, TextureCoordinate textureCoordinate, Coordinate coordinate, double baseX, double baseY, double scale, boolean affectLight, double tremblingAmplitude) {
        double x = baseX + coordinate.getX() * scale;
        double y = baseY + coordinate.getY() * scale;
        int width = (int)(coordinate.getWidth() * scale);
        int height = (int)(coordinate.getHeight() * scale);
        float u0 = (float)coordinate.getU0();
        float v0 = (float)coordinate.getV0();
        int uWidth = (int)coordinate.getUWidth();
        int vHeight = (int)coordinate.getVHeight();
        Random random = new Random();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.m_280168_().m_85836_();
        if (tremblingAmplitude > 0.0 && (!affectLight || WorldUtils.getEnvironmentBrightness((Player)Minecraft.m_91087_().f_91074_) > 4)) {
            x += ((double)random.nextFloat() - 0.5) * tremblingAmplitude;
            y += ((double)random.nextFloat() - 0.5) * tremblingAmplitude;
        }
        graphics.m_280168_().m_85837_(x, y, 0.0);
        GuiUtils.blit(graphics, texture, 0, 0, width, height, u0, v0, uWidth, vHeight, textureCoordinate.getTotalWidth(), textureCoordinate.getTotalHeight());
        graphics.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }

    public static MutableComponent setTextComponentColor(MutableComponent textComponent, int color) {
        return textComponent.m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)color)));
    }

    public static int getTextComponentColor(MutableComponent textComponent) {
        return GuiUtils.getTextComponentColor(textComponent, -1);
    }

    public static int getTextComponentColor(MutableComponent textComponent, int defaultColor) {
        return textComponent.m_7383_().m_131135_() == null ? defaultColor : textComponent.m_7383_().m_131135_().m_131265_();
    }

    public static MutableComponent textToComponent(Text text) {
        return Component.m_237113_((String)text.getContent()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)text.getColor())).m_131136_(Boolean.valueOf(text.isBold())).m_131155_(Boolean.valueOf(text.isItalic())).m_131162_(Boolean.valueOf(text.isUnderlined())).m_178522_(Boolean.valueOf(text.isStrikethrough())).m_178524_(Boolean.valueOf(text.isObfuscated())));
    }

    public static Text componentToText(MutableComponent component) {
        return Text.literal(component.getString()).setColor(GuiUtils.getTextComponentColor(component)).setBold(component.m_7383_().m_131154_()).setItalic(component.m_7383_().m_131161_()).setUnderlined(component.m_7383_().m_131171_()).setStrikethrough(component.m_7383_().m_131168_()).setObfuscated(component.m_7383_().m_131176_());
    }

    public static void drawString(GuiGraphics graphics, Font font, String text, float x, float y) {
        GuiUtils.drawString(Text.literal(text).setGraphics(graphics).setFont(font), x, y);
    }

    public static void drawString(GuiGraphics graphics, Font font, String text, float x, float y, int color) {
        GuiUtils.drawString(Text.literal(text).setColor(color).setGraphics(graphics).setFont(font), x, y);
    }

    public static void drawString(GuiGraphics graphics, Font font, String text, float x, float y, boolean shadow) {
        GuiUtils.drawString(Text.literal(text).setShadow(shadow).setGraphics(graphics).setFont(font), x, y);
    }

    public static void drawString(GuiGraphics graphics, Font font, String text, float x, float y, int color, boolean shadow) {
        GuiUtils.drawString(Text.literal(text).setColor(color).setShadow(shadow).setGraphics(graphics).setFont(font), x, y);
    }

    public static void drawString(Text text, float x, float y, EDepth depth) {
        if (depth != null) {
            GuiUtils.setDepth(text.getGraphics(), depth);
        }
        GuiUtils.drawString(text, x, y);
        if (depth != null) {
            GuiUtils.resetDepth(text.getGraphics());
        }
    }

    public static void drawString(Text text, float x, float y) {
        GuiUtils.drawLimitedText(text, x, y, 0, 0, null);
    }

    public static int multilineTextHeight(Text text) {
        return GuiUtils.multilineTextHeight(text.getFont(), text.getContent());
    }

    public static int multilineTextHeight(Font font, String text) {
        int n = StringUtils.replaceLine(text).split("\n").length;
        Objects.requireNonNull(font);
        return n * 9;
    }

    public static int getStringWidth(Font font, Collection<String> texts) {
        int width = 0;
        for (String s : texts) {
            width = Math.max(width, font.m_92895_(s));
        }
        return width;
    }

    public static int getStringHeight(Font font, Collection<String> texts) {
        return GuiUtils.multilineTextHeight(font, String.join((CharSequence)"\n", texts));
    }

    public static int getTextWidth(Font font, Collection<Text> texts) {
        int width = 0;
        for (Text text : texts) {
            for (String string : StringUtils.replaceLine(text.getContent()).split("\n")) {
                width = Math.max(width, font.m_92895_(string));
            }
        }
        return width;
    }

    public static int getTextHeight(Font font, Collection<Text> texts) {
        return GuiUtils.multilineTextHeight(font, texts.stream().map(Text::getContent).collect(Collectors.joining("\n")));
    }

    public static int multilineTextWidth(Text text) {
        return GuiUtils.multilineTextWidth(text.getFont(), text.getContent());
    }

    public static int multilineTextWidth(Font font, String text) {
        int width = 0;
        if (StringUtils.isNotNullOrEmpty(text)) {
            for (String s : StringUtils.replaceLine(text).split("\n")) {
                width = Math.max(width, font.m_92895_(s));
            }
        }
        return width;
    }

    public static void drawMultilineText(GuiGraphics graphics, Font font, String text, float x, float y, int ... colors) {
        GuiUtils.drawMultilineText(Text.literal(text).setGraphics(graphics).setFont(font), x, y, colors);
    }

    public static void drawMultilineText(@NonNull Text text, float x, float y, int ... colors) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (StringUtils.isNotNullOrEmpty(text.getContent())) {
            String[] lines = StringUtils.replaceLine(text.getContent()).split("\n");
            for (int i = 0; i < lines.length; ++i) {
                int color = colors.length == lines.length ? colors[i] : (colors.length > 0 ? colors[i % colors.length] : text.getColor());
                Text text2 = text.copy().setText(lines[i]).setColor(color);
                Objects.requireNonNull(text.getFont());
                GuiUtils.drawString(text2, x, y + (float)(i * 9));
            }
        }
    }

    public static void drawLimitedText(GuiGraphics graphics, Font font, String text, float x, float y, int maxWidth, int color) {
        GuiUtils.drawLimitedText(Text.literal(text).setGraphics(graphics).setFont(font).setColor(color).setShadow(true), x, y, maxWidth, 0, EllipsisPosition.END);
    }

    public static void drawLimitedText(GuiGraphics graphics, Font font, String text, float x, float y, int maxWidth, int color, boolean shadow) {
        GuiUtils.drawLimitedText(Text.literal(text).setGraphics(graphics).setFont(font).setColor(color).setShadow(shadow), x, y, maxWidth, 0, EllipsisPosition.END);
    }

    public static void drawLimitedText(GuiGraphics graphics, Font font, String text, float x, float y, int maxWidth, EllipsisPosition position, int color) {
        GuiUtils.drawLimitedText(Text.literal(text).setGraphics(graphics).setFont(font).setColor(color).setShadow(true), x, y, maxWidth, 0, position);
    }

    public static void drawLimitedText(GuiGraphics graphics, Font font, String text, float x, float y, int maxWidth, EllipsisPosition position, int color, boolean shadow) {
        GuiUtils.drawLimitedText(Text.literal(text).setGraphics(graphics).setFont(font).setColor(color).setShadow(shadow), x, y, maxWidth, 0, position);
    }

    public static void drawLimitedText(Text text, double x, double y, int maxWidth) {
        GuiUtils.drawLimitedText(text, x, y, maxWidth, 0, EllipsisPosition.END);
    }

    public static void drawLimitedText(Text text, double x, double y, int maxWidth, int maxLine) {
        GuiUtils.drawLimitedText(text, x, y, maxWidth, maxLine, EllipsisPosition.END);
    }

    public static void drawLimitedText(Text text, double x, double y, int maxWidth, EllipsisPosition position) {
        GuiUtils.drawLimitedText(text, x, y, maxWidth, 0, position);
    }

    /*
     * WARNING - void declaration
     */
    public static void drawLimitedText(Text text, double x, double y, int maxWidth, int maxLine, EllipsisPosition position) {
        if (StringUtils.isNotNullOrEmpty(text.getContent())) {
            String ellipsis = "...";
            Font font = text.getFont();
            int ellipsisWidth = font.m_92895_(ellipsis);
            String[] lines = StringUtils.replaceLine(text.getContent()).split("\n");
            if (maxLine <= 0 || maxLine >= lines.length) {
                maxLine = lines.length;
                position = null;
            }
            ArrayList<String> outputLines = new ArrayList<String>();
            if (position != null && maxLine > 1) {
                switch (position) {
                    case START: {
                        outputLines.add(ellipsis);
                        outputLines.addAll(Arrays.asList(lines).subList(lines.length - maxLine + 1, lines.length));
                        break;
                    }
                    case MIDDLE: {
                        int midStart = maxLine / 2;
                        int midEnd = lines.length - (maxLine - midStart) + 1;
                        outputLines.addAll(Arrays.asList(lines).subList(0, midStart));
                        outputLines.add(ellipsis);
                        outputLines.addAll(Arrays.asList(lines).subList(midEnd, lines.length));
                        break;
                    }
                    default: {
                        outputLines.addAll(Arrays.asList(lines).subList(0, maxLine - 1));
                        outputLines.add(ellipsis);
                        break;
                    }
                }
            } else if (maxLine == 1) {
                outputLines.add(lines[0]);
            } else {
                outputLines.addAll(Arrays.asList(lines));
            }
            int index = 0;
            int maxLineWidth = GuiUtils.multilineTextWidth(text);
            maxLineWidth = maxLine > 0 ? Math.min(maxLineWidth, maxWidth) : maxLineWidth;
            for (String string : outputLines) {
                void var16_14;
                if (maxWidth > 0 && font.m_92895_(string) > maxWidth) {
                    if (position == EllipsisPosition.START) {
                        void var16_16;
                        while (font.m_92895_(ellipsis + (String)var16_16) > maxWidth && var16_16.length() > 1) {
                            String string2 = var16_16.substring(1);
                        }
                        String string3 = ellipsis + (String)var16_16;
                    } else if (position == EllipsisPosition.END) {
                        void var16_19;
                        while (font.m_92895_((String)var16_19 + ellipsis) > maxWidth && var16_19.length() > 1) {
                            String string4 = var16_19.substring(0, var16_19.length() - 1);
                        }
                        String string5 = (String)var16_19 + ellipsis;
                    } else {
                        int halfWidth = (maxWidth - ellipsisWidth) / 2;
                        String start = string;
                        String end = string;
                        while (font.m_92895_(start) > halfWidth && start.length() > 1) {
                            start = start.substring(0, start.length() - 1);
                        }
                        while (font.m_92895_(end) > halfWidth && end.length() > 1) {
                            end = end.substring(1);
                        }
                        String string6 = start + ellipsis + end;
                    }
                }
                float xOffset = switch (text.getAlign()) {
                    case Text.Align.CENTER -> (float)(maxLineWidth - font.m_92895_((String)var16_14)) / 2.0f;
                    case Text.Align.RIGHT -> maxLineWidth - font.m_92895_((String)var16_14);
                    default -> 0.0f;
                };
                GuiGraphics graphics = text.getGraphics();
                FormattedCharSequence formattedCharSequence = GuiUtils.textToComponent(text.copy().setText((String)var16_14)).m_7532_();
                float f = (float)x + xOffset;
                float f2 = (float)y;
                Objects.requireNonNull(font);
                graphics.drawString(font, formattedCharSequence, f, f2 + (float)(index * 9), text.getColor(), text.isShadow());
                ++index;
            }
        }
    }

    public static void drawEffectIcon(GuiGraphics graphics, Font font, MobEffectInstance mobEffectInstance, ResourceLocation textureLocation, TextureCoordinate textureCoordinate, int x, int y, int width, int height, boolean showText) {
        ResourceLocation effectIcon = TextureUtils.getEffectTexture(mobEffectInstance);
        if (effectIcon == null) {
            Coordinate buffUV = textureCoordinate.getBuffUV();
            GuiUtils.blit(graphics, textureLocation, x, y, width, height, (float)buffUV.getU0(), (float)buffUV.getV0(), (int)buffUV.getUWidth(), (int)buffUV.getVHeight(), textureCoordinate.getTotalWidth(), textureCoordinate.getTotalHeight());
        } else {
            GuiUtils.blit(graphics, effectIcon, x, y, 0.0f, 0.0f, width, height, width, height);
        }
        if (showText) {
            float fontY;
            float fontX;
            if (mobEffectInstance.m_19564_() >= 0) {
                MutableComponent amplifierString = Component.m_237113_((String)StringUtils.intToRoman(mobEffectInstance.m_19564_() + 1));
                int amplifierWidth = font.m_92852_((FormattedText)amplifierString);
                fontX = (float)(x + width) - (float)amplifierWidth / 2.0f;
                fontY = y - 1;
                graphics.m_280614_(font, (Component)amplifierString, (int)fontX, (int)fontY, 0xFFFFFF, true);
            }
            if (mobEffectInstance.m_19557_() > 0) {
                MutableComponent durationString = Component.m_237113_((String)DateUtils.toMaxUnitString(mobEffectInstance.m_19557_(), DateUtils.DateUnit.SECOND, 0, 1));
                int durationWidth = font.m_92852_((FormattedText)durationString);
                fontX = (float)(x + width) - (float)durationWidth / 2.0f - 2.0f;
                fontY = (float)y + (float)height / 2.0f + 1.0f;
                graphics.m_280614_(font, (Component)durationString, (int)fontX, (int)fontY, 0xFFFFFF, true);
            }
        }
    }

    public static void drawCustomIcon(GuiGraphics graphics, Font font, Component reward, ResourceLocation textureLocation, Coordinate textureUV, int x, int y, int totalWidth, int totalHeight, boolean showText) {
        GuiUtils.blit(graphics, textureLocation, x, y, 16, 16, (float)textureUV.getU0(), (float)textureUV.getV0(), (int)textureUV.getUWidth(), (int)textureUV.getVHeight(), totalWidth, totalHeight);
        if (showText) {
            int numWidth = font.m_92852_((FormattedText)reward);
            float fontX = (float)(x + 16) - (float)numWidth / 2.0f - 2.0f;
            float f = (float)y + 16.0f;
            Objects.requireNonNull(font);
            float fontY = f - 9.0f + 2.0f;
            graphics.m_280648_(font, reward.m_7532_(), (int)fontX, (int)fontY, 0xFFFFFF);
        }
    }

    public static void renderItem(GuiGraphics graphics, Font fontRenderer, ItemStack itemStack, int x, int y, boolean showText) {
        graphics.m_280480_(itemStack, x, y);
        if (showText) {
            graphics.m_280302_(fontRenderer, itemStack, x, y, String.valueOf(itemStack.m_41613_()));
        }
    }

    public static void drawPixel(GuiGraphics graphics, int x, int y, int color) {
        GuiUtils.fill(graphics, x, y, 1, 1, color);
    }

    public static void fill(GuiGraphics graphics, int x, int y, int width, int color) {
        GuiUtils.fill(graphics, x, y, width, width, color);
    }

    public static void fill(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        GuiUtils.fill(graphics, x, y, width, height, color, 0);
    }

    public static void fill(GuiGraphics graphics, int x, int y, int width, int height, int color, int radius) {
        if (radius <= 0) {
            graphics.m_280509_(x, y, x + width, y + height, color);
            return;
        }
        radius = Math.min(radius, 10);
        GuiUtils.fill(graphics, x + radius + 1, y + radius + 1, width - 2 * (radius + 1), height - 2 * (radius + 1), color);
        GuiUtils.fill(graphics, x + radius + 1, y, width - 2 * radius - 2, radius, color);
        GuiUtils.fill(graphics, x + radius + 1, y + radius, width - 2 * (radius + 1), 1, color);
        GuiUtils.fill(graphics, x + radius + 1, y + height - radius, width - 2 * radius - 2, radius, color);
        GuiUtils.fill(graphics, x + radius + 1, y + height - radius - 1, width - 2 * (radius + 1), 1, color);
        GuiUtils.fill(graphics, x, y + radius + 1, radius, height - 2 * radius - 2, color);
        GuiUtils.fill(graphics, x + radius, y + radius + 1, 1, height - 2 * (radius + 1), color);
        GuiUtils.fill(graphics, x + width - radius, y + radius + 1, radius, height - 2 * radius - 2, color);
        GuiUtils.fill(graphics, x + width - radius - 1, y + radius + 1, 1, height - 2 * (radius + 1), color);
        GuiUtils.drawCircleQuadrant(graphics, x + radius, y + radius, radius, color, 1);
        GuiUtils.drawCircleQuadrant(graphics, x + width - radius - 1, y + radius, radius, color, 2);
        GuiUtils.drawCircleQuadrant(graphics, x + radius, y + height - radius - 1, radius, color, 3);
        GuiUtils.drawCircleQuadrant(graphics, x + width - radius - 1, y + height - radius - 1, radius, color, 4);
    }

    private static void drawCircleQuadrant(GuiGraphics graphics, int centerX, int centerY, int radius, int color, int quadrant) {
        for (int dx = 0; dx <= radius; ++dx) {
            block7: for (int dy = 0; dy <= radius; ++dy) {
                if (dx * dx + dy * dy > radius * radius) continue;
                switch (quadrant) {
                    case 1: {
                        GuiUtils.drawPixel(graphics, centerX - dx, centerY - dy, color);
                        continue block7;
                    }
                    case 2: {
                        GuiUtils.drawPixel(graphics, centerX + dx, centerY - dy, color);
                        continue block7;
                    }
                    case 3: {
                        GuiUtils.drawPixel(graphics, centerX - dx, centerY + dy, color);
                        continue block7;
                    }
                    case 4: {
                        GuiUtils.drawPixel(graphics, centerX + dx, centerY + dy, color);
                    }
                }
            }
        }
    }

    public static void fillOutLine(GuiGraphics graphics, int x, int y, int width, int height, int thickness, int color) {
        GuiUtils.fill(graphics, x, y, width, thickness, color);
        GuiUtils.fill(graphics, x, y + height - thickness, width, thickness, color);
        GuiUtils.fill(graphics, x, y, thickness, height, color);
        GuiUtils.fill(graphics, x + width - thickness, y, thickness, height, color);
    }

    public static void fillOutLine(GuiGraphics graphics, int x, int y, int width, int height, int thickness, int color, int radius) {
        if (radius <= 0) {
            GuiUtils.fillOutLine(graphics, x, y, width, height, thickness, color);
        } else {
            radius = Math.min(radius, 10);
            GuiUtils.fill(graphics, x + radius, y, width - 2 * radius, thickness, color);
            GuiUtils.fill(graphics, x + radius, y + height - thickness, width - 2 * radius, thickness, color);
            GuiUtils.fill(graphics, x, y + radius, thickness, height - 2 * radius, color);
            GuiUtils.fill(graphics, x + width - thickness, y + radius, thickness, height - 2 * radius, color);
            GuiUtils.drawCircleBorder(graphics, x + radius, y + radius, radius, thickness, color, 1);
            GuiUtils.drawCircleBorder(graphics, x + width - radius - 1, y + radius, radius, thickness, color, 2);
            GuiUtils.drawCircleBorder(graphics, x + radius, y + height - radius - 1, radius, thickness, color, 3);
            GuiUtils.drawCircleBorder(graphics, x + width - radius - 1, y + height - radius - 1, radius, thickness, color, 4);
        }
    }

    private static void drawCircleBorder(GuiGraphics graphics, int centerX, int centerY, int radius, int thickness, int color, int quadrant) {
        for (int dx = 0; dx <= radius; ++dx) {
            block7: for (int dy = 0; dy <= radius; ++dy) {
                double sqrt = Math.sqrt(dx * dx + dy * dy);
                if (!(sqrt <= (double)radius) || !(sqrt >= (double)(radius - thickness))) continue;
                switch (quadrant) {
                    case 1: {
                        GuiUtils.drawPixel(graphics, centerX - dx, centerY - dy, color);
                        continue block7;
                    }
                    case 2: {
                        GuiUtils.drawPixel(graphics, centerX + dx, centerY - dy, color);
                        continue block7;
                    }
                    case 3: {
                        GuiUtils.drawPixel(graphics, centerX - dx, centerY + dy, color);
                        continue block7;
                    }
                    case 4: {
                        GuiUtils.drawPixel(graphics, centerX + dx, centerY + dy, color);
                    }
                }
            }
        }
    }

    public static void drawPopupMessage(GuiGraphics graphics, Font font, String message, int x, int y, int screenWidth, int screenHeight) {
        GuiUtils.drawPopupMessage(graphics, font, message, x, y, screenWidth, screenHeight, -1, -1442840576);
    }

    public static void drawPopupMessage(GuiGraphics graphics, Font font, String message, int x, int y, int screenWidth, int screenHeight, int textColor, int bgColor) {
        GuiUtils.drawPopupMessage(graphics, font, message, x, y, screenWidth, screenHeight, 2, textColor, bgColor);
    }

    public static void drawPopupMessage(GuiGraphics graphics, Font font, String message, int x, int y, int screenWidth, int screenHeight, int margin, int textColor, int bgColor) {
        GuiUtils.drawPopupMessage(graphics, font, message, x, y, screenWidth, screenHeight, margin, margin, textColor, bgColor);
    }

    public static void drawPopupMessage(GuiGraphics graphics, Font font, String message, int x, int y, int screenWidth, int screenHeight, int margin, int padding, int textColor, int bgColor) {
        GuiUtils.drawPopupMessage(Text.literal(message).setGraphics(graphics).setFont(font).setColor(textColor), x, y, screenWidth, screenHeight, margin, padding, bgColor);
    }

    public static void drawPopupMessage(Text text, int x, int y, int screenWidth, int screenHeight) {
        GuiUtils.drawPopupMessage(text, x, y, screenWidth, screenHeight, -1442840576);
    }

    public static void drawPopupMessage(Text text, int x, int y, int screenWidth, int screenHeight, int bgColor) {
        GuiUtils.drawPopupMessage(text, x, y, screenWidth, screenHeight, 2, bgColor);
    }

    public static void drawPopupMessage(Text text, int x, int y, int screenWidth, int screenHeight, int margin, int bgColor) {
        GuiUtils.drawPopupMessage(text, x, y, screenWidth, screenHeight, margin, margin, bgColor);
    }

    public static void drawPopupMessage(Text text, int x, int y, int screenWidth, int screenHeight, int margin, int padding, int bgColor) {
        boolean hasRightSpace;
        int msgWidth = GuiUtils.multilineTextWidth(text) + padding;
        int msgHeight = GuiUtils.multilineTextHeight(text) + padding;
        if (msgWidth >= screenWidth) {
            msgWidth = screenWidth - padding * 2;
        }
        if (msgHeight >= screenHeight) {
            msgHeight = screenHeight - padding * 2;
        }
        int adjustedX = x - msgWidth / 2;
        int adjustedY = y - msgHeight - 5;
        boolean hasTopSpace = adjustedY >= margin;
        boolean hasLeftSpace = adjustedX >= margin;
        boolean bl = hasRightSpace = adjustedX + msgWidth <= screenWidth - margin;
        if (!hasTopSpace) {
            adjustedY = y + 1 + 5;
        } else if (!hasLeftSpace) {
            adjustedX = margin;
        } else if (!hasRightSpace) {
            adjustedX = screenWidth - msgWidth - margin;
        }
        adjustedX = Math.max(margin, Math.min(adjustedX, screenWidth - msgWidth - margin));
        adjustedY = Math.max(margin, Math.min(adjustedY, screenHeight - msgHeight - margin));
        GuiUtils.setDepth(text.getGraphics(), EDepth.POPUP_TIPS);
        GuiUtils.fill(text.getGraphics(), adjustedX, adjustedY, msgWidth, msgHeight, bgColor);
        double d = (float)adjustedX + (float)padding / 2.0f;
        double d2 = (float)adjustedY + (float)padding / 2.0f;
        Objects.requireNonNull(text.getFont());
        GuiUtils.drawLimitedText(text, d, d2, msgWidth, msgHeight / 9, EllipsisPosition.MIDDLE);
        GuiUtils.resetDepth(text.getGraphics());
    }

    public static EditBox newTextFieldWidget(Font font, int x, int y, int width, int height, Component content) {
        return new EditBox(font, x, y, width, height, content);
    }

    public static Button newButton(int x, int y, int width, int height, Component content, Button.OnPress onPress) {
        return Button.m_253074_((Component)content, (Button.OnPress)onPress).m_252794_(x, y).m_253046_(width, height).m_253136_();
    }

    public static enum EDepth {
        BACKGROUND(1),
        FOREGROUND(250),
        OVERLAY(500),
        TOOLTIP(750),
        POPUP_TIPS(900),
        MOUSE(1000);

        private final int depth;

        private EDepth(int depth) {
            this.depth = depth;
        }

        @Generated
        public int getDepth() {
            return this.depth;
        }
    }

    public static enum EllipsisPosition {
        START,
        MIDDLE,
        END;

    }
}

