/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.container;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;

public class FaceContainer {
    public Container inv;
    public Direction face;
    public WorldlyContainer sidedInv;
    public int[] slots;

    public FaceContainer(Container inv, Direction side) {
        this.inv = inv;
        this.face = side;
        if (inv instanceof WorldlyContainer) {
            this.sidedInv = (WorldlyContainer)inv;
            this.slots = this.sidedInv.m_7071_(this.face);
        } else {
            this.slots = new int[inv.m_6643_()];
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = i;
            }
        }
    }

    public FaceContainer(Container inv) {
        this(inv, Direction.DOWN);
    }

    public FaceContainer(Container inv, int firstSlot, int lastSlot) {
        this.inv = inv;
        this.slots = new int[lastSlot - firstSlot];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = firstSlot + i;
        }
    }

    public FaceContainer(Container inv, FaceContainer access) {
        this.inv = inv;
        this.slots = access.slots;
        this.face = access.face;
        if (inv instanceof WorldlyContainer) {
            this.sidedInv = (WorldlyContainer)inv;
        }
    }

    public boolean canInsertItem(int slot, @Nonnull ItemStack item) {
        return this.sidedInv == null ? this.inv.m_7013_(slot, item) : this.sidedInv.m_7155_(slot, item, this.face);
    }

    public boolean canExtractItem(int slot, @Nonnull ItemStack item) {
        return this.sidedInv == null ? this.inv.m_7013_(slot, item) : this.sidedInv.m_7157_(slot, item, this.face);
    }

    public int lastSlot() {
        int last = 0;
        for (int slot : this.slots) {
            if (slot <= last) continue;
            last = slot;
        }
        return last;
    }
}

