/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.wrapper;

import committee.nova.mods.avaritia.common.wrappers.StorageItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.util.StorageUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.function.IntSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public abstract class OffsetItemStackWrapper
implements IItemHandlerModifiable {
    public static OffsetItemStackWrapper create(final Int2ObjectMap<StorageItem> containers, final IntSupplier offset, final IntSupplier length) {
        return new OffsetItemStackWrapper(){

            @Override
            protected Int2ObjectMap<StorageItem> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return offset.getAsInt();
            }

            @Override
            public int getSlots() {
                return length.getAsInt();
            }
        };
    }

    public static OffsetItemStackWrapper create(final Int2ObjectMap<StorageItem> containers, final int offset, final int length) {
        return new OffsetItemStackWrapper(){

            @Override
            protected Int2ObjectMap<StorageItem> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return offset;
            }

            @Override
            public int getSlots() {
                return length;
            }
        };
    }

    public static OffsetItemStackWrapper create(Int2ObjectMap<StorageItem> containers) {
        IntIterator it = containers.keySet().iterator();
        int slots = -1;
        while (it.hasNext()) {
            slots = Math.max(slots, it.nextInt());
        }
        return OffsetItemStackWrapper.create(containers, 0, slots + 1);
    }

    public static OffsetItemStackWrapper create(Int2ObjectMap<StorageItem> containers, int offset) {
        IntIterator it = containers.keySet().iterator();
        int slots = -1;
        while (it.hasNext()) {
            slots = Math.max(slots, it.nextInt());
        }
        int page = slots / 54 + 1;
        return OffsetItemStackWrapper.create(containers, 0, slots + 1);
    }

    public static OffsetItemStackWrapper dummy(final int length) {
        final Int2ObjectMap<StorageItem> containers = StorageUtils.newContainers();
        return new OffsetItemStackWrapper(){

            @Override
            protected Int2ObjectMap<StorageItem> getContainers() {
                return containers;
            }

            @Override
            protected int getOffset() {
                return 0;
            }

            @Override
            public int getSlots() {
                return length;
            }
        };
    }

    protected abstract Int2ObjectMap<StorageItem> getContainers();

    protected abstract int getOffset();

    public abstract int getSlots();

    public StorageItem getContainerInSlot(int slot) {
        int adjustedSlot = this.getOffset() + slot;
        return (StorageItem)this.getContainers().get(adjustedSlot);
    }

    public void setContainerInSlot(int slot, StorageItem container) {
        this.getContainers().put(this.getOffset() + slot, (Object)container);
    }

    public StorageItem removeContainerInSlot(int slot) {
        return (StorageItem)this.getContainers().remove(this.getOffset() + slot);
    }

    public long getSlotLimitLong(int slot) {
        return (Long)ModConfig.slotStackLimit.get();
    }

    public long getSlotFreeSpace(int slot) {
        return this.getSlotLimitLong(slot) - this.getContainerInSlot(slot).getCount();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            this.removeContainerInSlot(slot);
        } else {
            int size = (int)Math.min((long)stack.m_41613_(), this.getSlotLimitLong(slot));
            this.setContainerInSlot(slot, StorageItem.create(stack, size));
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        StorageItem container = this.getContainerInSlot(slot);
        ItemStack stack = container.getStack();
        int size = (int)Math.min(container.getCount(), (long)stack.m_41741_());
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(container.getCount() > 64L ? (int)container.getCount() : size));
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        StorageItem container = this.getContainerInSlot(slot);
        ItemStack stackInSlot = container.getStack();
        long limit = this.getSlotLimitLong(slot);
        if (!container.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            limit -= container.getCount();
        }
        if (limit <= 0L) {
            return stack;
        }
        int toInsert = (int)Math.min((long)stack.m_41613_(), limit);
        if (!simulate) {
            if (container.isEmpty()) {
                this.setContainerInSlot(slot, StorageItem.create(stack, toInsert));
            } else {
                container.grow(toInsert);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - toInsert));
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        StorageItem container = this.getContainerInSlot(slot);
        if (container.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = container.getStack();
        long stackCount = container.getCount();
        int toExtract = (int)Math.min(Math.min((long)amount, stackCount), (long)stackInSlot.m_41741_());
        if (!simulate) {
            if (stackCount > (long)toExtract) {
                container.shrink(toExtract);
            } else {
                this.removeContainerInSlot(slot);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

